<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Password List</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-6 md:ml-64">
            <!-- Top Navigation -->
            <div class="flex flex-col md:flex-row justify-between items-center bg-white shadow p-4 rounded-lg mb-6">
                <!-- Search Input -->
                <input type="text" id="search" placeholder="Search..." class="p-2 border border-gray-300 rounded-lg w-full md:w-1/3 mb-4 md:mb-0" oninput="filterTable()">

                <!-- Filter Dropdown for User Type -->
                <select id="user-type-filter" class="p-2 border border-gray-300 rounded-lg w-full md:w-1/4" onchange="filterTable()">
                    <option value="">All User Types</option>
                    <option value="admin">Admin</option>
                    <option value="user">User</option>
                </select>
            </div>

            <!-- Table Section -->
            <div class="container mx-auto p-6">
                <h2 class="text-2xl font-bold text-gray-700 mb-4">User Password List</h2>

                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white border border-gray-300 rounded-md">
                        <thead>
                            <tr>
                                <th class="p-4 border-b text-xs sm:text-sm md:text-base">ID</th>
                                <th class="p-4 border-b text-xs sm:text-sm md:text-base">Name</th>
                                <th class="p-4 border-b text-xs sm:text-sm md:text-base">Email</th>
                                <th class="p-4 border-b text-xs sm:text-sm md:text-base">Phone</th>
                                <th class="p-4 border-b text-xs sm:text-sm md:text-base">Password</th>
                                <th class="p-4 border-b text-xs sm:text-sm md:text-base">User Type</th>
                            </tr>
                        </thead>
                        <tbody id="table-body">
                            <?php
                            // Example database connection
                            $conn = new mysqli("localhost", "username", "password", "database_name");

                            // Query to fetch user details from the database
                            $query = "SELECT id, name, email, phone, password, user_type FROM users";
                            $result = $conn->query($query);

                            if ($result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    echo "<tr>";
                                    echo "<td class='p-4 text-xs sm:text-sm md:text-base'>" . $row['id'] . "</td>";
                                    echo "<td class='p-4 text-xs sm:text-sm md:text-base'>" . $row['name'] . "</td>";
                                    echo "<td class='p-4 text-xs sm:text-sm md:text-base'>" . $row['email'] . "</td>";
                                    echo "<td class='p-4 text-xs sm:text-sm md:text-base'>" . $row['phone'] . "</td>";
                                    echo "<td class='p-4 text-xs sm:text-sm md:text-base'>" . $row['password'] . "</td>";
                                    echo "<td class='p-4 text-xs sm:text-sm md:text-base'>" . $row['user_type'] . "</td>";
                                    echo "</tr>";
                                }
                            } else {
                                echo "<tr><td colspan='6' class='p-4 text-center'>No records found</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="mt-4">
                    <nav>
                        <ul class="flex justify-center space-x-2">
                            <?php
                            for ($i = 1; $i <= $total_pages; $i++) {
                                echo "<li><a href='?page=$i&status=$status_filter' class='p-2 border rounded " . ($page == $i ? 'bg-blue-600 text-white' : 'bg-gray-200') . "'>$i</a></li>";
                            }
                            ?>
                        </ul>
                    </nav>
                </div> </div> <?php include "footer.php";?>
        </main>
    </div>

    <!-- Footer -->
   

    <script>
        // Function to filter the table based on search input and user type filter
        function filterTable() {
            const searchInput = document.getElementById("search").value.toLowerCase();
            const userTypeFilter = document.getElementById("user-type-filter").value;
            const tableRows = document.querySelectorAll("#table-body tr");

            tableRows.forEach(row => {
                const cells = row.querySelectorAll("td");
                let match = false;

                // Loop through each cell and check if it contains the search input or user type filter
                cells.forEach(cell => {
                    if (cell.textContent.toLowerCase().includes(searchInput)) {
                        match = true;
                    }
                });

                // Show or hide the row based on match
                row.style.display = match && (userTypeFilter === "" || row.cells[5].textContent.toLowerCase().includes(userTypeFilter.toLowerCase())) ? "" : "none";
            });
        }
    </script>
</body>
</html>
