<?php
session_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);
include "config.php"; // Ensure this file connects to your database

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}


?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Become a PAMM Money Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

   <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
   <div class="container">
        <h1 class="text-3xl font-bold text-center text-[#CD7F32] mb-6">Become a PAMM Money Manager</h1>

            <form action="submit_pamm_manager.php" method="POST">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Minimum Investment -->
                    <div>
                        <label for="min_investment" class="block text-[#CD7F32] font-semibold mb-2">Minimum Investment ($):</label>
                        <input type="number" id="min_investment" name="min_investment" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter amount" min="1">
                    </div>

                    <!-- Performance Fee -->
                    <div>
                        <label for="performance_fee" class="block text-[#CD7F32] font-semibold mb-2">Performance Fee (%):</label>
                        <input type="number" id="performance_fee" name="performance_fee" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter fee" min="1" max="100">
                    </div>

                    <!-- Select Fee Type -->
                    <div>
                        <label for="fee_type" class="block text-[#CD7F32] font-semibold mb-2">Select Per Deal/Per Lot:</label>
                        <select id="fee_type" name="fee_type" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required>
                            <option value="">-- Select Type --</option>
                            <option value="per_deal">Per Deal</option>
                            <option value="per_lot">Per Lot</option>
                        </select>
                    </div>

                    <!-- Per Deal / Per Lot Fee -->
                    <div>
                        <label for="fee_amount" class="block text-[#CD7F32] font-semibold mb-2">Per Deal/Per Lot:</label>
                        <input type="number" id="fee_amount" name="fee_amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter fee amount" min="0.01">
                    </div>
                </div>

                <!-- Agreement Checkbox -->
                <div class="mt-6">
                    <input type="checkbox" id="agree" name="agree" required class="mr-2">
                    <label for="agree" class="text-gray-700">
                        I agree to the 
                        <a href="terms.php" class="text-[#CD7F32] font-semibold underline">Terms & Conditions</a> and 
                        <a href="privacy.php" class="text-[#CD7F32] font-semibold underline">Privacy Policy</a>.
                    </label>
                </div>

                <!-- Submit Button -->
                <div class="mt-6 text-center">
                    <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                        Submit
                    </button>
                </div>
            </form>
        </div><br><br><br><?php include "footer.php";?>
    </main>
</div>
</body>
</html>
