<?php

include 'config.php';

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
    exit();
}

// Handle password update (no hashing, direct update)
if (isset($_POST['change_password'])) {
    $new_pass = $_POST['new_password'] ?? '';
    $confirm  = $_POST['confirm_password'] ?? '';
    $uname_for_update = $_SESSION['clogin'];

    if ($new_pass === '' || $confirm === '') {
        echo "<script>alert('Please fill all password fields.');</script>";
    } elseif ($new_pass !== $confirm) {
        echo "<script>alert('Passwords do not match.');</script>";
    } else {
        try {
            $sql = "UPDATE aspnetusers SET password = :pwd WHERE email = :mail";
            $stmt = $conn->prepare($sql);
            $stmt->bindValue(':pwd',  $new_pass, PDO::PARAM_STR);
            $stmt->bindValue(':mail', $uname_for_update, PDO::PARAM_STR);
            $stmt->execute();
            echo "<script>alert('Password updated successfully.');</script>";
        } catch (Throwable $e) {
            $m = addslashes($e->getMessage());
            echo "<script>alert('Error updating password: {$m}');</script>";
        }
    }
}

// Get the logged-in user's email from session
$uname = $_SESSION['clogin'];

// Fetch user data from database
$sql = "SELECT * FROM aspnetusers WHERE email = :uname";
$query = $conn->prepare($sql);
$query->bindValue(':uname', $uname, PDO::PARAM_STR);
$query->execute();
$user = $query->fetch(PDO::FETCH_OBJ);

if (!$user) {
    session_destroy();
    header("Location: login.php");
    exit();
}

$username = $user->username ?? $user->email;
$fullname = $user->fullname ?? 'User';
$mail     = $user->email;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

    <!-- (Your existing CSS links) -->

    <link rel="stylesheet" href="https://test.traderssolution.com/crmvideonew/assets/css/core/libs.min.css" />
    <link rel="stylesheet" href="https://test.traderssolution.com/crmvideonew/assets/vendor/aos/dist/aos.css" />
    <link rel="stylesheet" href="https://test.traderssolution.com/crmvideonew/assets/css/hope-ui.min.css?v=2.0.0" />
    <link rel="stylesheet" href="https://test.traderssolution.com/crmvideonew/assets/css/custom.min.css?v=2.0.0" />
    <link rel="stylesheet" href="https://test.traderssolution.com/crmvideonew/assets/css/dark.min.css"/>
    <link rel="stylesheet" href="https://test.traderssolution.com/crmvideonew/assets/css/rtl.min.css"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://kit.fontawesome.com/a076d05399.js"></script>
<style>.header {
  width: calc(100% - 250px); /* leave space for sidebar */
  margin-left: 250px;        /* shift right after sidebar */
  position: fixed;
  top: 0;
  height: 60px;
  background: #fff; /* or your header color */
  z-index: 1000;
}/* Sidebar hidden by default */
.sidebar {
  width: 250px;
  transition: all 0.3s;
}

.sidebar.active {
  margin-left: -250px; /* or display:none */
}
</style>
    <style>
     /* === Fixed, sticky header === */
#tree{
  position: fixed;     /* changed from sticky */
  top: 0; left: 0; right: 0;
  z-index: 9999;
  background: rgba(255,255,255,.95);
  backdrop-filter: saturate(180%) blur(6px);
  border-bottom: 1px solid #f1f5f9;
  width: 100%;
  /* optional nice effect */
  transition: box-shadow .2s ease, backdrop-filter .2s ease, height .2s ease;
}
#tree.scrolled{
  box-shadow: 0 6px 20px rgba(0,0,0,.08);
}

      /* Dropdown animation */
      #dropdownMenu {
        transition: all 0.3s ease;
        transform-origin: top right;
        opacity: 0;
        transform: scale(0.95) translateY(-10px);
      }
      #dropdownMenu.show {
        opacity: 1;
        transform: scale(1) translateY(0);
        display: block !important;
      }
      /* Modal: disable body scroll when open */
      body.modal-open {
        overflow: hidden;
      }
      .nav-item {
  list-style: none;   /* removes the dot */
}
    </style>
</head>

<body class="bg-gray-100 flex m-0 p-0">

<header class="bg-white shadow-md p-4 flex items-center w-full relative" id="tree">
    <?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($conn) || !($conn instanceof PDO)) {  // allow $dbh fallback
  if (isset($dbh) && $dbh instanceof PDO) { $conn = $dbh; }
}

$userEmail = $_SESSION['clogin'] ?? null;
$unread_count = 0;
$unread_items = [];

if ($userEmail && isset($conn)) {
  // Count unread = news without a read-row for this user
  $sqlCount = "
    SELECT COUNT(*) 
    FROM news n
    LEFT JOIN news_reads r
      ON r.news_id = n.id AND r.user_email = :email
    WHERE r.news_id IS NULL
  ";
  $st = $conn->prepare($sqlCount);
  $st->execute([':email' => $userEmail]);
  $unread_count = (int)$st->fetchColumn();

  // Fetch a few latest unread titles
  $sqlList = "
    SELECT n.id, n.title, n.created_at
    FROM news n
    LEFT JOIN news_reads r
      ON r.news_id = n.id AND r.user_email = :email
    WHERE r.news_id IS NULL
    ORDER BY n.created_at DESC, n.id DESC
    LIMIT 10
  ";
  $st2 = $conn->prepare($sqlList);
  $st2->execute([':email' => $userEmail]);
  $unread_items = $st2->fetchAll(PDO::FETCH_ASSOC);
}
?><!-- Sidebar Toggle Button -->
<button id="sidebarToggle" class="btn btn-outline-primary me-2" style="color:orange;">
  ☰ <!-- Bootstrap icon -->
</button>



  
<!-- Centered brand -->
<a href="dashboard.php"
   class="absolute left-1/2 -translate-x-1/2 inline-flex items-center">
  <img src="https://test.traderssolution.com/crmvideonew/demo.png"
       alt="Logo" class="h-9 w-auto" />
</a>


<div class="relative flex items-center space-x-4 ml-auto">

        <div class="flex items-center space-x-2"><!-- Notification bell -->
<li class="nav-item dropdown">
  <a class="nav-link" href="#" data-bs-toggle="dropdown" aria-expanded="false" style="position:relative;">
    <i class="fa fa-bell"></i>
    <?php if (!empty($unread_count)): ?>
      <span style="
        position:absolute; top:-4px; right:-6px; 
        background:#e11d48; color:#fff; 
        border-radius:999px; font-size:11px; 
        padding:2px 6px; line-height:1;">
        <?= htmlspecialchars($unread_count) ?>
      </span>
    <?php endif; ?>
  </a>
  <div class="dropdown-menu dropdown-menu-end p-0" style="min-width:300px;">
    <div class="p-2" style="border-bottom:1px solid #eee; font-weight:700;">News</div>
    <div style="max-height:320px; overflow:auto;">
      <?php if ($unread_items): ?>
        <?php foreach ($unread_items as $n): ?>
          <a class="dropdown-item d-flex align-items-start" 
             href="news.php?id=<?= (int)$n['id'] ?>&src=notif">
            <div>
              <div style="font-weight:600;"><?= htmlspecialchars($n['title']) ?></div>
              <div style="font-size:12px; color:#64748b;">
                <?= htmlspecialchars($n['created_at']) ?>
              </div>
            </div>
          </a>
        <?php endforeach; ?>
      <?php else: ?>
        <div class="px-3 py-2 text-muted">No new news</div>
      <?php endif; ?>
    </div>
    <?php if ($unread_items): ?>
    
    <?php endif; ?>
  </div>
</li>
            <img src="https://randomuser.me/api/portraits/men/50.jpg" alt="Admin" class="w-10 h-8 rounded-full border-2 border-orange-600">
            <button class="bg-orange-600 text-white py-2 px-4 rounded-full flex items-center space-x-2" id="dropdownButton">
                <span class="text-sm"><?php echo htmlspecialchars($username); ?></span>
                <i class="fas fa-caret-down"></i>
            </button>
        </div>

        <!-- Dropdown Menu -->
        <div class="absolute right-0 mt-5 w-52 bg-white rounded-md shadow-lg hidden z-50" id="dropdownMenu">
            <div class="p-4">
                <p class="font-semibold text-gray-700"><?php echo htmlspecialchars($fullname); ?></p>
                <p class="text-sm text-gray-500"><?php echo htmlspecialchars($mail); ?></p>
            </div>
            <div class="border-t border-gray-200">
                
                <a href="profile.php" class="block px-4 py-2 text-gray-700 hover:bg-gray-100">
                    <i class="fa fa-user mr-2"></i> Profile
                </a>
                <button type="button" id="openPasswordModal" class="w-full text-left px-4 py-2 text-gray-700 hover:bg-gray-100">
                    <i class="fa fa-key mr-2"></i> Change Password
                </button>
                <a href="logout.php" class="block px-4 py-2 text-gray-700 hover:bg-gray-100">
                    <i class="fa fa-sign-out mr-2"></i> Logout
                </a>
            </div>
        </div>
    </div>
</header>

<!-- ===================== Password Update Modal (Centered) ===================== -->
<div id="passwordModal" class="fixed inset-0 hidden items-center justify-center z-[10000]">
  <!-- Backdrop -->
  <div class="absolute inset-0 bg-black/50" id="passwordModalBackdrop"></div>

  <!-- Modal Card -->
  <div class="relative bg-white w-full max-w-md mx-4 rounded-2xl shadow-2xl p-6">
    <div class="flex items-center justify-between mb-4">
      <h3 class="text-lg font-semibold">Update Password</h3>
      <button type="button" id="closePasswordModal" class="text-gray-500 hover:text-gray-700">
        <i class="fa fa-times"></i>
      </button>
    </div>

    <form method="post" onsubmit="return validatePassForm();">
      <input type="hidden" name="change_password" value="1" />

      <div class="mb-4">
        <label class="block text-sm font-medium text-gray-700 mb-1">New Password</label>
        <input type="password" name="new_password" id="new_password" class="w-full border rounded-lg px-3 py-2 focus:outline-none focus:ring focus:border-orange-500" required>
      </div>

      <div class="mb-6">
        <label class="block text-sm font-medium text-gray-700 mb-1">Confirm New Password</label>
        <input type="password" name="confirm_password" id="confirm_password" class="w-full border rounded-lg px-3 py-2 focus:outline-none focus:ring focus:border-orange-500" required>
      </div>

      <div class="flex items-center justify-end gap-3">
        <button type="button" id="cancelPasswordModal" class="px-4 py-2 rounded-lg border border-gray-300 hover:bg-gray-50">Cancel</button>
        <button type="submit" class="px-4 py-2 rounded-lg bg-orange-600 text-white hover:bg-orange-700">Update</button>
      </div>
    </form>
  </div>
</div>
<!-- =================== /Password Update Modal =================== -->

<script>
  // Dropdown
  document.getElementById('dropdownButton').addEventListener('click', function(e) {
      e.stopPropagation();
      const dropdown = document.getElementById('dropdownMenu');
      dropdown.classList.toggle('show');
      dropdown.classList.toggle('hidden');
  });
  document.addEventListener('click', function(e) {
      const dropdown = document.getElementById('dropdownMenu');
      if (dropdown && !dropdown.contains(e.target) && e.target.id !== 'dropdownButton') {
          dropdown.classList.remove('show');
          dropdown.classList.add('hidden');
      }
  });

  // Modal open/close handlers
  const modal = document.getElementById('passwordModal');
  const openBtn = document.getElementById('openPasswordModal');
  const closeBtn = document.getElementById('closePasswordModal');
  const cancelBtn = document.getElementById('cancelPasswordModal');
  const backdrop = document.getElementById('passwordModalBackdrop');

  function openModal() {
    modal.classList.remove('hidden');
    modal.classList.add('flex'); // center with flex
    document.body.classList.add('modal-open');
  }
  function closeModal() {
    modal.classList.add('hidden');
    modal.classList.remove('flex');
    document.body.classList.remove('modal-open');
    // optional: clear fields
    const np = document.getElementById('new_password');
    const cp = document.getElementById('confirm_password');
    if (np) np.value = '';
    if (cp) cp.value = '';
  }

  if (openBtn) openBtn.addEventListener('click', function(e) {
    e.preventDefault();
    openModal();
  });
  if (closeBtn) closeBtn.addEventListener('click', closeModal);
  if (cancelBtn) cancelBtn.addEventListener('click', closeModal);
  if (backdrop) backdrop.addEventListener('click', closeModal);

  // Simple client-side validation (match only)
  function validatePassForm() {
    const np = document.getElementById('new_password').value.trim();
    const cp = document.getElementById('confirm_password').value.trim();
    if (!np || !cp) {
      alert('Please fill both password fields.');
      return false;
    }
    if (np !== cp) {
      alert('Passwords do not match.');
      return false;
    }
    return true;
  }
</script>
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const sidebar = document.getElementById("sidebar");  // your sidebar div
    const toggleBtn = document.getElementById("sidebarToggle");

    toggleBtn.addEventListener("click", function () {
      sidebar.classList.toggle("active");
    });
  });
</script>
<script>
document.addEventListener('DOMContentLoaded', () => {
  const header = document.getElementById('tree');
  if (!header) return;

  const setBodyOffset = () => {
    document.body.style.paddingTop = header.offsetHeight + 'px';
  };
  setBodyOffset();
  window.addEventListener('resize', setBodyOffset);

  const onScroll = () => {
    if (window.scrollY > 6) header.classList.add('scrolled');
    else header.classList.remove('scrolled');
  };
  document.addEventListener('scroll', onScroll);
  onScroll();
});
</script>

</body>
</html>
