<?php
// footer.php — Minimal, totally different orange/white footer (no menus)
// Drop-in replacement. No dependencies. Uses current year automatically.
$year = date('Y');
?>
<style>
  :root{
    --brand:#F1671B; --brand-700:#d65a12;
    --ink:#0f172a; --muted:#94a3b8;
    --bg:#ffffff; --soft:#FFF5ED; --line:#ececec;
    --shadow:0 8px 22px rgba(0,0,0,.06);
  }
  .kf-foot{
    margin-top:24px;
    background:var(--bg);
    border-top:1px solid var(--line);
  }
  /* Thin orange accent bar */
  .kf-foot-accent{
    height:4px;
    background: linear-gradient(90deg, var(--brand), #ff9952);
  }
  .kf-foot-wrap{
    max-width:1200px; margin:0 auto; padding:18px 16px;
    display:flex; align-items:center; gap:12px;
  }
  .kf-foot-left{
    display:flex; align-items:center; gap:10px; min-width:0;
  }
  .kf-foot-logo{
    width:32px; height:32px; border-radius:10px;
    display:grid; place-items:center; color:#fff; font-weight:800; font-size:14px;
    background:linear-gradient(135deg,var(--brand),#ff9952); box-shadow:var(--shadow);
  }
  .kf-foot-brand{
    font-weight:800; color:var(--ink); letter-spacing:.2px; white-space:nowrap;
  }
  .kf-foot-grow{flex:1}
  .kf-foot-center{
    text-align:center; color:var(--muted); font-weight:600; font-size:14px;
    min-width:0; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;
  }
  .kf-foot-right{
    display:flex; align-items:center; gap:10px;
  }
  .kf-tag{
    padding:6px 10px; border-radius:999px; border:1px solid var(--line);
    background:#fff; color:#6b7280; font-weight:700; font-size:12px;
  }
  /* Back-to-top button (subtle) */
  .kf-top{
    display:inline-flex; align-items:center; gap:6px;
    padding:8px 12px; border-radius:999px; border:1px solid var(--line);
    background:#fff; color:#374151; font-weight:700; text-decoration:none;
    transition:.15s ease;
  }
  .kf-top:hover{ border-color:#ffd7c0; color:var(--brand) }
  @media (max-width: 680px){
    .kf-foot-wrap{flex-direction:column; align-items:flex-start; gap:10px}
    .kf-foot-center{order:3; text-align:left; white-space:normal}
    .kf-foot-right{order:2}
  }
</style>

<footer class="kf-foot" role="contentinfo">
  <div class="kf-foot-accent"></div>
  <div class="kf-foot-wrap">
    <!-- Left: brand -->
    <div class="kf-foot-left">
      <div class="kf-foot-logo">DM</div>
      <div class="kf-foot-brand">Demo Markets</div>
    </div>

    <div class="kf-foot-grow"></div>

    <!-- Center: copyright / disclaimer -->
    <div class="kf-foot-center">
      © <?= $year ?> Demo Markets. All rights reserved.
    </div>

    <!-- Right: small status + back to top -->
    <div class="kf-foot-right">
      <span class="kf-tag">Secure • SSL</span>
      <a href="#top" class="kf-top" aria-label="Back to top">↑ Top</a>
    </div>
  </div>
</footer>
