<?php
// header.php — Minimal top header (NO NAV, NO EXTRAS)
// Uses session + $dbh to show the signed-in user's name.
// Safe fallback if $dbh isn't set.

if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($dbh)) { @include_once __DIR__ . '/config.php'; }

$currentUserEmail = $_SESSION['clogin'] ?? $_SESSION['alogin'] ?? '';
$userName = 'User';
if (!empty($currentUserEmail) && isset($dbh)) {
  try {
    $st = $dbh->prepare("SELECT fullname FROM aspnetusers WHERE email = :e LIMIT 1");
    $st->bindParam(':e', $currentUserEmail, PDO::PARAM_STR);
    $st->execute();
    $row = $st->fetch(PDO::FETCH_ASSOC);
    if (!empty($row['fullname'])) $userName = $row['fullname'];
  } catch (Throwable $e) {}
}
$avatarLetter = strtoupper(mb_substr($userName, 0, 1, 'UTF-8'));

// Page label (middle). If you set $header_title on a page, it’ll use that.
$path  = parse_url($_SERVER['REQUEST_URI'] ?? '', PHP_URL_PATH) ?? '';
$base  = strtolower(basename($path));
$map   = [
  'dashboard' => 'Dashboard',
  'dashboard.php' => 'Dashboard',
  'clients'   => 'Clients',
  'clients.php'=> 'Clients',
  'trades'    => 'Trade List',
  'trades.php'=> 'Trade List',
  'withdraw' => 'Payout',
  'withdraw.php'=> 'Payout',
];
$defaultTitle = $map[$base] ?? 'Demo Markets';
$headerTitle  = isset($header_title) && $header_title !== '' ? $header_title : $defaultTitle;
?>
<style>
  :root{
    --brand:#F1671B; --brand-700:#d65a12;
    --ink:#0f172a; --muted:#94a3b8;
    --bg:#ffffff; --soft:#FFF5ED; --line:#ececec;
    --shadow:0 8px 22px rgba(0,0,0,.06);
    --r-lg:14px; --r-md:12px;
  }
  .kf-min-header{
    position:sticky; top:0; z-index:900;
    background:var(--bg); border-bottom:1px solid var(--line);
  }
  .kf-min-wrap{
    max-width:1200px; margin:0 auto; padding:10px 16px;
    display:flex; align-items:center; gap:12px;
  }
  /* Brand (left) */
  .kf-brand{display:flex; align-items:center; gap:10px; min-width:0}
  .kf-logo{
    width:36px; height:36px; border-radius:12px; display:grid; place-items:center; color:#fff; font-weight:800;
    background:linear-gradient(135deg,var(--brand),#ff9952); box-shadow:var(--shadow);
  }
  .kf-brand-name{font-weight:800; color:var(--ink); letter-spacing:.2px; white-space:nowrap}
  /* Middle title */
  .kf-grow{flex:1}
  .kf-page-title{
    font-weight:800; color:var(--ink); letter-spacing:.2px; text-align:center;
  }
  @media (max-width: 680px){
    .kf-page-title{font-size:14px}
    .kf-brand-name{display:none}
  }
  /* User chip (right) */
  .kf-user{position:relative}
  .kf-chip{
    display:flex; align-items:center; gap:10px; padding:6px 10px;
    border:1px solid var(--line); background:#fff; border-radius:999px; cursor:pointer;
  }
  .kf-av{
    width:28px; height:28px; border-radius:50%; display:grid; place-items:center;
    background:var(--soft); color:var(--brand); font-weight:800;
  }
  .kf-name{
    max-width:160px; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;
    color:var(--ink); font-weight:700; font-size:14px;
  }
  .kf-caret{color:var(--muted); font-size:12px}
  .kf-menu{
    position:absolute; right:0; top:44px; min-width:200px;
    background:#fff; border:1px solid var(--line); border-radius:var(--r-lg); box-shadow:var(--shadow);
    padding:6px; display:none;
  }
  .kf-menu.open{display:block}
  .kf-mi{
    display:flex; align-items:center; gap:8px; padding:10px 12px; border-radius:10px;
    color:#374151; text-decoration:none; font-weight:600;
  }
  .kf-mi:hover{background:var(--soft); color:var(--brand)}
</style>

<header class="kf-min-header">
  <div class="kf-min-wrap">
    <!-- Left: brand -->
    <div class="kf-brand">
      <div class="kf-logo">DM</div>
      <div class="kf-brand-name">Demo Markets</div>
    </div>

    <!-- Middle: page label -->
    <div class="kf-grow"></div>
    <div class="kf-page-title" aria-label="Page">
      <?= htmlspecialchars($headerTitle) ?>
    </div>
    <div class="kf-grow"></div>

    <!-- Right: user -->
    <div class="kf-user">
      <div class="kf-chip" id="kf-chip" aria-haspopup="true" aria-expanded="false" title="<?= htmlspecialchars($userName) ?>">
        <div class="kf-av"><?= htmlspecialchars($avatarLetter) ?></div>
        <div class="kf-name"><?= htmlspecialchars($userName) ?></div>
        
      </div>
   
    </div>
  </div>
</header>

<script>
(function(){
  const chip = document.getElementById('kf-chip');
  const menu = document.getElementById('kf-menu');
  function closeAll(){ menu?.classList.remove('open'); chip?.setAttribute('aria-expanded','false'); }
  chip?.addEventListener('click', (e)=>{
    e.stopPropagation();
    const open = menu?.classList.contains('open');
    closeAll();
    if (!open){ menu?.classList.add('open'); chip?.setAttribute('aria-expanded','true'); }
  });
  document.addEventListener('click', (e)=>{
    if (!menu) return;
    if (!menu.contains(e.target) && !chip.contains(e.target)) closeAll();
  });
})();
</script>
