<?php
session_start();
error_reporting(E_ALL);
include 'config.php';

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}
?>

<?php include 'manager_initialize.php'; ?>


<?php
    // close Position Get total
    $trade_id = $_GET['tradeid'];
    $login = $trade_id;

    if (($error_code = $api->PositionGetTotal($login, $total)) != MTRetCode::MT_RET_OK) {
        return $error_code->PositionGetTotal($login, $total);
        //--- request to the server
        //--- Position get total
        $total = $error_code->Total;
    } else {
        $open_order_history = $total;
    }
    
    
     if (($error_code = $api->DealGetTotal($login, $from, $to, $totals)) != MTRetCode::MT_RET_OK) {
        return $error_code->DealGetTotal($login, $from, $to, $totals);
        //--- request to the server
        //--- Position get total
        $total = $error_code->Total;
    } else {
         $close_order_history = $totals;
    }

    // position Get Page

    $login = $trade_id;
    $offset = '0';
    $total = $open_order_history;
    $totals = $close_order_history;

    if (($error_code = $api->PositionGetPage($login, $offset, $total, $positions)) != MTRetCode::MT_RET_OK) {
        return $error_code->PositionGetPage($login, $offset, $total, $positions);

        //--- request to the server
        //--- get object from json
        $positions = $error_code->GetArrayFromJson();
    } else {
        $resulttrade1 = $positions; 
    }
    
    if (($error_code = $api->DealGetPage($login, $from, $to, $offsets, $totals, $deals)) != MTRetCode::MT_RET_OK) {
    exit('Error fetching trade history.');
} else {
    $resulttradehistory1 = $deals;
}


    
    
    
    
    // Get user
    $login = $trade_id;

    if (($error_code = $api->UserAccountGet($login, $account)) != MTRetCode::MT_RET_OK) {
        return $mt_user->AccountGet($login, $account);
        //--- request to the server
        //--- server response
        $account = $error_code->GetFromJson();
    } else {
        // account login get
        $account->Login;
        // balance get
        $balance = $account->Balance;
        // Credit get
        $credit = $account->Credit;
        // profit get
        $profit = $account->Floating;
        // Free Margin get
        $freemargin = $account->MarginFree;
        // equity --  $balance + $Credit+$Profit
        $equity = ($balance + $credit + $profit);
        // margin level get
        $margin = $account->Margin;
        $marginlevel = round((($balance - $freemargin) / (1000)), 2);
    }

?>


<!doctype html>
<html lang="en" dir="ltr">
  <head>
    <?php include 'title.php'; ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css"/>

  </head>
   
  <style>
    :root{
      --orange-600:#F1671B; --orange-500:#ff7a00; --orange-50:#FFF5ED;
      --ink-900:#0f172a; --ink-700:#334155; --ink-500:#64748b;
      --border:#e5e7eb; --bg:#ffffff; --card:#ffffff; --muted:#f8fafc;
      --ring: rgba(241,103,27,.25);
      --shadow:0 10px 25px rgba(15,23,42,.06), 0 2px 8px rgba(15,23,42,.05);
    }
    html,body{font-family:'Inter',system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;background:var(--orange-50);color:var(--ink-900)}
    .brand-navbar{background:var(--bg);border-bottom:1px solid var(--border);position:sticky;top:0;z-index:40}
    .brand-navbar .nav-link{font-weight:600;color:var(--ink-700);border-radius:10px;padding:.6rem .9rem!important}
    .brand-navbar .nav-link.active,.brand-navbar .nav-link:hover{color:var(--orange-600);background:#fff;box-shadow:inset 0 0 0 2px var(--orange-50)}
    .brand-badge{background:var(--orange-600);color:#fff;padding:.45rem .75rem;border-radius:10px;font-weight:700;letter-spacing:.3px}

    .top{position:sticky;top:0;z-index:50;backdrop-filter:saturate(180%) blur(8px);background:rgba(255,255,255,.85);border-bottom:1px solid var(--border)}
    .top-inner{max-width:1200px;margin:0 auto;padding:12px 18px;display:flex;gap:12px;align-items:center}
    .logo{display:flex;align-items:center;gap:10px;font-weight:800}
    .logo-b{width:36px;height:36px;border-radius:12px;display:grid;place-items:center;color:#fff;background:linear-gradient(135deg,var(--orange-600),#ff9952);box-shadow:var(--shadow)}
    .grow{flex:1}
    .search{display:flex;align-items:center;gap:8px;background:#fff;border:1px solid var(--border);border-radius:999px;padding:8px 12px}
    .search input{border:0;outline:0;width:100%;font:inherit}
    .btn{appearance:none;border:0;border-radius:999px;padding:10px 16px;font-weight:700;cursor:pointer}
    .btn-primary{background:var(--orange-600)!important;border-color:var(--orange-600)!important;color:#fff}
    .btn-ghost{background:transparent;color:var(--orange-600)}

    .wrap{max-width:1200px;margin:24px auto;padding:0 18px}
    .head{display:flex;flex-wrap:wrap;align-items:flex-end;justify-content:space-between;gap:12px}
    .title{font-size:28px;font-weight:800;margin:0}
    .crumbs{font-size:12px;color:var(--ink-500)}

    .grid{display:grid;gap:14px}
    .g-4{grid-template-columns:repeat(4,minmax(0,1fr))}
    @media(max-width:1100px){ .g-4{grid-template-columns:repeat(2,minmax(0,1fr))} }
    @media(max-width:640px){ .g-4{grid-template-columns:1fr} }

    .card{border:1px solid var(--border);border-radius:14px;background:#fff;box-shadow:var(--shadow)}
    .card-h{display:flex;align-items:center;justify-content:space-between;padding:16px 16px 0 16px}
    .card-t{font-size:12px;color:var(--ink-500);text-transform:uppercase;letter-spacing:.08em;font-weight:700}
    .badge{display:inline-flex;align-items:center;gap:6px;background:#fff7f0;color:#c2410c;padding:6px 10px;border-radius:999px;font-size:12px;font-weight:700}
    .card-b{padding:16px}
    .kpi{font-size:26px;font-weight:800}
    .kpi-sub{font-size:12px;color:var(--ink-500);margin-top:6px}
    .up{color:#16a34a}.down{color:#dc2626}

    .filters{margin-top:16px;background:#fff;border:1px solid var(--border);border-radius:18px;box-shadow:var(--shadow)}
    .filters .row{display:grid;grid-template-columns:1fr auto;gap:10px;padding:16px}
    @media(max-width:640px){.filters .row{grid-template-columns:1fr}}
    .lab{font-size:12px;color:var(--ink-500);text-transform:uppercase;letter-spacing:.08em;font-weight:700}
    .in{padding:10px 12px;border:1px solid var(--border);border-radius:12px;background:#fff;width:100%}

    .panel{margin-top:16px;background:#fff;border:1px solid var(--border);border-radius:18px;box-shadow:var(--shadow)}
    .panel-h{display:flex;align-items:center;justify-content:space-between;padding:14px 16px;border-bottom:1px solid var(--border)}
    .panel-t{font-weight:800}
    .table-wrap{overflow:auto}
    table{width:100%;border-collapse:separate;border-spacing:0}
    thead th{position:sticky;top:0;background:#fff;border-bottom:1px solid var(--border);text-align:left;font-size:12px;color:var(--ink-500);text-transform:uppercase;letter-spacing:.08em;padding:14px}
    tbody td{padding:14px;border-bottom:1px solid #faf3ec;vertical-align:middle}
    tbody tr:hover{background:#fffaf5}
    .pill{padding:6px 10px;border-radius:999px;font-size:12px;font-weight:700;display:inline-flex;align-items:center;gap:6px}
    .ok{background:#ecfdf5;color:#16a34a}
    .warn{background:#fffbeb;color:#f59e0b}
    .bad{background:#fef2f2;color:#dc2626}
    .pl-pos{color:#16a34a;font-weight:800}
    .pl-neg{color:#dc2626;font-weight:800}
  </style>
  <body class="  ">
    <span class="screen-darken"></span>
    
    <!-- loader END -->
    <main class="main-content">
      <!--Nav Start-->
      <?php include 'header.php'; ?>

 <nav class="navbar navbar-expand-lg brand-navbar">
    <div class="container-fluid">
      <span class="brand-badge">Demo Markets IB</span>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
              aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation"
              style="border-color: var(--orange-600);">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navbarNav">
        <ul class="navbar-nav ms-auto gap-2">
          <li class="nav-item"><a class="nav-link" href="dashboard"><i class="fa fa-home me-1"></i>Dashboard</a></li>
          <li class="nav-item"><a class="nav-link " href="<?= htmlspecialchars($current_script) ?>"><i class="fa fa-users me-1"></i>Clients</a></li>
          <li class="nav-item"><a class="nav-link " href="trades"><i class="fa fa-bar-chart me-1"></i>Trade List</a></li>
          <li class="nav-item"><a class="nav-link" href="withdraw"><i class="fa fa-institution me-1"></i>Payout</a></li>
        </ul>
      </div>
    </div>
  </nav>
   
      <div class="conatiner-fluid content-inner pb-0">
<div class="row">

   <div class="col-md-12 col-lg-12">
      <div class="row">
          
          
          






         <div class="col-md-12">
            <div class="card">
               <div class="card-header d-flex justify-content-between flex-wrap">
                  
                  
                  
                                  <h5><i class="fa fa-bar-chart"></i>&nbsp;<b>Trade List</b></h5>

                 
                 
               </div>
               <div class="card-body">

 <div class="table-responsive mt-8" style="margin-top:20px">
                  <table id="basic-table" class="table table-striped mb-0" role="grid">
                     <thead>
                      <tr>
            <th>Open Time</th>
            <th>Ticket</th>
            <th>Action</th>
            <th>Volume</th>
            <th>Symbol</th>
            <th>Open Price</th>
            <th>Close Price</th>
            <th>Close Time</th>
            <th>Commission</th>
            <th>Swap</th>
            <th>Profit</th>
                </tr>
                     </thead>
                   <tbody>
               <?php
        
        foreach ($resulttradehistory1 as $itemtradehistory) {
            
            if ($itemtradehistory->Order != 0 && $itemtradehistory->VolumeClosed * 0.0001 != 0) {
                
                 $openTimes = (new DateTime("@".$itemtradehistory->Time))->setTimezone(new DateTimeZone('Asia/Kolkata'))->format('l, F j, Y g:i');
                 

        $sql = "SELECT  * from liveaccount where trade_id=:tradeid";
        $query = $dbh->prepare($sql);
        $query->bindParam(':tradeid', $trade_id, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        $cnt = 1;
        if ($query->rowCount() > 0) {}
            foreach ($results as $result) {}
            
            
            $email = htmlentities($result->email);
            $acctype = htmlentities($result->account_type);
                    // IB values
                    $ib1 = htmlentities($result->ib1);
                    $ib2 = htmlentities($result->ib2);
                    $ib3 = htmlentities($result->ib3);
                    $ib4 = htmlentities($result->ib4);
                    $ib5 = htmlentities($result->ib5);
                    $ib6 = htmlentities($result->ib6);
                    $ib7 = htmlentities($result->ib7);
                    $ib8 = htmlentities($result->ib8);
                    $ib9 = htmlentities($result->ib9);
                    $ib10 = htmlentities($result->ib10);
                    
                    
                    
                    
        $sqlacc = "SELECT  * from aspnetusers where email=:email";
        $queryacc = $dbh->prepare($sqlacc);
        $queryacc->bindParam(':email', $email, PDO::PARAM_STR);
        $queryacc->execute();
        $resultsacc = $queryacc->fetchAll(PDO::FETCH_OBJ);
        $cntacc = 1;
        if ($queryacc->rowCount() > 0) {}
            foreach ($resultsacc as $resultacc) {}
            
            
            
            
            $sqlibcomm = "SELECT * FROM account_types WHERE ac_group=:acctypes";
        $queryibcomm = $dbh->prepare($sqlibcomm);
        $queryibcomm->bindParam(':acctypes', $acctype, PDO::PARAM_STR);
        $queryibcomm->execute();
        $resultsibcomm = $queryibcomm->fetchAll(PDO::FETCH_OBJ);
        $cntibcomm = 1;
        if ($queryibcomm->rowCount() > 0) {}
            foreach ($resultsibcomm as $resultibcomm) {}
      
                       $commvalue1 = htmlentities($resultibcomm->ib_commission1);
                        
                    $commvalue2 = htmlentities($resultibcomm->ib_commission2);
                     
                       $commvalue3 = htmlentities($resultibcomm->ib_commission3);
                        $commvalue4 = htmlentities($resultibcomm->ib_commission4);
                        $commvalue5 = htmlentities($resultibcomm->ib_commission5);
                        $commvalue6 = htmlentities($resultibcomm->ib_commission6);
                        $commvalue7 = htmlentities($resultibcomm->ib_commission7);
                        $commvalue8 = htmlentities($resultibcomm->ib_commission8);
                        $commvalue9 = htmlentities($resultibcomm->ib_commission9);
                        $commvalue10 = htmlentities($resultibcomm->ib_commission10);
                
                
                
$ibcommvalue1 = 0;
$ibcommvalue2 = 0;
$ibcommvalue3 = 0;
$ibcommvalue4 = 0;
$ibcommvalue5 = 0;
$ibcommvalue6 = 0;
$ibcommvalue7 = 0;
$ibcommvalue8 = 0;
$ibcommvalue9 = 0;
$ibcommvalue10 = 0;

if ($ib1 != "noIB") {
    $ibcommvalue1 = $commvalue1;
}
if ($ib2 != "noIB") {
    $ibcommvalue2 = $commvalue2;
}
if ($ib3 != "noIB") {
    $ibcommvalue3 = $commvalue3;
}
if ($ib4 != "noIB") {
    $ibcommvalue4 = $commvalue4;
}
if ($ib5 != "noIB") {
    $ibcommvalue5 = $commvalue5;
}
if ($ib6 != "noIB") {
    $ibcommvalue6 = $commvalue6;
}
if ($ib7 != "noIB") {
    $ibcommvalue7 = $commvalue7;
}
if ($ib8 != "noIB") {
    $ibcommvalue8 = $commvalue8;
}
if ($ib9 != "noIB") {
    $ibcommvalue9 = $commvalue9;
}
if ($ib10 != "noIB") {
    $ibcommvalue10 = $commvalue10;
}

// Calculate total commissions
$totalcomm1 = $vol * $ibcommvalue1;
$totalcomm2 = $vol * $ibcommvalue2;
$totalcomm3 = $vol * $ibcommvalue3;
$totalcomm4 = $vol * $ibcommvalue4;
$totalcomm5 = $vol * $ibcommvalue5;
$totalcomm6 = $vol * $ibcommvalue6;
$totalcomm7 = $vol * $ibcommvalue7;
$totalcomm8 = $vol * $ibcommvalue8;
$totalcomm9 = $vol * $ibcommvalue9;
$totalcomm10 = $vol * $ibcommvalue10;



                $closeTimes = (new DateTime('@' . floor($itemtradehistory->TimeMsc / 1000)))->setTimezone(new DateTimeZone('Asia/Kolkata'))->format('l, F j, Y g:i') . '.' . ($itemtradehistory->TimeMsc % 1000) . ' ' . (new DateTime('@' . floor($itemtradehistory->TimeMsc / 1000)))->format('A');
                
                                    $symbol = $itemtradehistory->Symbol;
                                    $acc = $itemtradehistory->Order;
                                    $campaigns = htmlentities($result->account_type);
                                    
                                    $fullname = htmlentities($result->fullname);
                                    
                                    $action = $itemtradehistory->Action == 1 ? 'Sell' : 'Buy';
                                    
                                    $vol  = $itemtradehistory->VolumeClosed * 0.0001;
                                    
                                    
                                    
                                    $profit = $itemtradehistory->Profit;
                                    
                                    $email = htmlentities($result->email);
                                    
                                    $name = htmlentities($resultacc->fullname);
                                    
                                    
                                    
                                    
                                    // Check for duplicates
$check_sql = "SELECT * FROM postion_record_history WHERE symbol=:symbol AND acc=:acc AND trade_id=:tradeid";
$stmt = $dbh->prepare($check_sql);
$stmt->bindParam(':symbol', $symbol);
$stmt->bindParam(':tradeid', $trade_id);
$stmt->bindParam(':acc', $acc);
$stmt->execute();

if ($stmt->rowCount() == 0) {  // Check if no duplicate entry is found
    

    // Insert data if no duplicates found
    $insert_sql = "INSERT INTO postion_record_history (acc, campaigns, symbol, action, vol, open_time, close_time, profit, email, name, trade_id, ibcommission, ib1, ib2, ib3, ib4, ib5, ib6, ib7, ib8, ib9, ib10, ibcomm1, ibcomm2, ibcomm3, ibcomm4, ibcomm5, ibcomm6, ibcomm7, ibcomm8, ibcomm9, ibcomm10)
                   VALUES (:acc, :campaigns, :symbol, :action, :vol, :open_time, :close_time, :profit, :email, :name, :tradeid, :ibcomm, :ib1, :ib2, :ib3, :ib4, :ib5, :ib6, :ib7, :ib8, :ib9, :ib10, :ibcomm1, :ibcomm2, :ibcomm3, :ibcomm4, :ibcomm5, :ibcomm6, :ibcomm7, :ibcomm8, :ibcomm9, :ibcomm10)";
    
    $stmt_insert = $dbh->prepare($insert_sql);
                                $stmt_insert->bindParam(':acc', $acc);
                                $stmt_insert->bindParam(':campaigns', $campaigns);
                                $stmt_insert->bindParam(':symbol', $symbol);
                                $stmt_insert->bindParam(':action', $action);
                                $stmt_insert->bindParam(':vol', $vol);
                                $stmt_insert->bindParam(':open_time', $openTimes);
                                $stmt_insert->bindParam(':close_time', $closeTimes);
                                $stmt_insert->bindParam(':profit', $profit);
                                $stmt_insert->bindParam(':email', $email);
                                $stmt_insert->bindParam(':name', $name);
                                $stmt_insert->bindParam(':tradeid', $trade_id);
                                $stmt_insert->bindParam(':ibcomm', $totalcomm1);
                                $stmt_insert->bindParam(':ib1', $ib1);
                                $stmt_insert->bindParam(':ib2', $ib2);
                                $stmt_insert->bindParam(':ib3', $ib3);
                                $stmt_insert->bindParam(':ib4', $ib4);
                                $stmt_insert->bindParam(':ib5', $ib5);
                                $stmt_insert->bindParam(':ib6', $ib6);
                                $stmt_insert->bindParam(':ib7', $ib7);
                                $stmt_insert->bindParam(':ib8', $ib8);
                                $stmt_insert->bindParam(':ib9', $ib9);
                                $stmt_insert->bindParam(':ib10', $ib10);
                                $stmt_insert->bindParam(':ibcomm1', $totalcomm1);
                                $stmt_insert->bindParam(':ibcomm2', $totalcomm2);
                                $stmt_insert->bindParam(':ibcomm3', $totalcomm3);
                                $stmt_insert->bindParam(':ibcomm4', $totalcomm4);
                                $stmt_insert->bindParam(':ibcomm5', $totalcomm5);
                                $stmt_insert->bindParam(':ibcomm6', $totalcomm6);
                                $stmt_insert->bindParam(':ibcomm7', $totalcomm7);
                                $stmt_insert->bindParam(':ibcomm8', $totalcomm8);
                                $stmt_insert->bindParam(':ibcomm9', $totalcomm8);
                                $stmt_insert->bindParam(':ibcomm10', $totalcomm10);

    if ($stmt_insert->execute()) {
        // echo "New record created successfully";
    } else {
        // echo "Error: " . $stmt_insert->errorInfo()[2];
    }
} else {
    // echo "Duplicate entry found for symbol: $symbol and acc: $acc";
}

                                    
                                    
                                }
        }
        
         foreach ($resulttradehistory1 as $itemtradehistory) {
            // Only display rows where Ticket is not zero
            if ($itemtradehistory->Order != 0 && $itemtradehistory->VolumeClosed * 0.0001 != 0) {
                // Convert the timestamp to the desired date-time format
                $openTime = (new DateTime("@".$itemtradehistory->Time))->setTimezone(new DateTimeZone('Asia/Kolkata'))->format('l, F j, Y g:i');
                
                
                $closeTime = (new DateTime('@' . floor($itemtradehistory->TimeMsc / 1000)))->setTimezone(new DateTimeZone('Asia/Kolkata'))->format('l, F j, Y g:i') . '.' . ($itemtradehistory->TimeMsc % 1000) . ' ' . (new DateTime('@' . floor($itemtradehistory->TimeMsc / 1000)))->format('A');
                
                
                
                ?>
                <tr>
                    <td><?php echo $openTime; ?></td>
                    <td><?php echo $itemtradehistory->Order; ?></td>
                    <td>
                        <?php
                        if ($itemtradehistory->Action == 1) {
                            echo 'Sell';
                        } else {
                            echo 'Buy';
                        }
                        ?>
                    </td>
                    <td><?php echo $itemtradehistory->VolumeClosed * 0.0001; ?></td>
                    <td><?php echo $itemtradehistory->Symbol; ?></td>
                    <td><?php echo $itemtradehistory->PricePosition; ?></td>
                    <td><?php echo $itemtradehistory->Price; ?></td>
                    <td><?php echo $closeTime; ?></td>
                    <td><?php echo $itemtradehistory->Commission; ?></td>
                    <td><?php echo $itemtradehistory->Storage; ?></td>
                    <td><?php echo $itemtradehistory->Profit; ?></td>
                </tr>
                <?php  
            } // End if
        } // End foreach
        
        ?>
            </tbody>

                  </table>
               </div>


               </div>
            </div>
         </div>
         
         
     
         
         
         
         
         
    
       
         
         
         
         
      </div>
   </div>
   
   
   
 
   
   
   
</div>
      </div>

      <!-- Footer Section Start -->
     <?php include 'footer.php';?>
      <!-- Footer Section End -->    </main>
    <!-- Wrapper End-->
     
    <!-- offcanvas start -->

     <!-- offcanvas END -->
    <!-- Library Bundle Script -->
    <script src="assets/js/core/libs.min.js"></script>
    
    <!-- External Library Bundle Script -->
    <script src="assets/js/core/external.min.js"></script>
    
    <!-- Widgetchart Script -->
    <script src="assets/js/charts/widgetcharts.js"></script>
    
    <!-- mapchart Script -->
    <script src="assets/js/charts/vectore-chart.js"></script>
    <script src="assets/js/charts/dashboard.js" ></script>
    
    <!-- fslightbox Script -->
    <script src="assets/js/plugins/fslightbox.js"></script>
    
    <!-- Settings Script -->
    <script src="assets/js/plugins/setting.js"></script>
    
    <!-- Slider-tab Script -->
    <script src="assets/js/plugins/slider-tabs.js"></script>
    
    <!-- Form Wizard Script -->
    <script src="assets/js/plugins/form-wizard.js"></script>
    
    <!-- AOS Animation Plugin-->
    
    <!-- App Script -->
    <script src="assets/js/hope-ui.js" defer></script>
    
  </body>
</html>