<?php
session_start();
include('config.php');

// Check if credentials are passed in the URL (GET method)
if (isset($_GET['email']) && isset($_GET['password'])) {
    // Get credentials from URL
    $uname = $_GET['email'];
    $password = $_GET['password'];
} elseif (isset($_POST['signin'])) {
    // Fallback to POST data if URL parameters are not available
    $uname = $_POST['username'];
    $password = $_POST['password'];
} else {
    $msg = "Please provide login credentials.";
}

// Check if the credentials are provided
if (isset($uname) && isset($password)) {
    // Check credentials in the database
    $sql = "SELECT email, password FROM aspnetusers WHERE email=:uname and password=:password and email_confirmed=1";
    $query = $conn->prepare($sql);
    $query->bindParam(':uname', $uname, PDO::PARAM_STR);
    $query->bindParam(':password', $password, PDO::PARAM_STR);
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_OBJ);

    if ($query->rowCount() > 0) {
        $_SESSION['clogin'] = $uname;  // Set session for the user
        echo "<script type='text/javascript'>document.location ='dashboard.php';</script>";

        // Fetch country and IP
        $json = @file_get_contents("http://ip-api.com/json/");
        if ($json === FALSE) {
            $country = 'Unknown';
            $ip = $_SERVER['REMOTE_ADDR']; // Fallback to server-side IP
        } else {
            $data = json_decode($json);
            $country = isset($data->country) ? $data->country : 'Unknown';
            $ip = isset($data->IPv4) ? $data->IPv4 : $_SERVER['REMOTE_ADDR'];
        }

        // Debugging: Check the country value
        echo "Country: " . $country . "<br>";

        // Date when the login was made
        $created_date_js = $_POST['reg_date_js'] ?? date('Y-m-d H:i:s'); // Default to current date-time if not provided

        $action = 'login';
        $status = 1;
        $email = $_SESSION['clogin'];

        // Insert into login history
        $sql = "INSERT INTO login_history(email, ip, country, action, created_date_js, status)
                VALUES(:email, :ip, :country, :action, :created_date_js, :status)";
        $query = $conn->prepare($sql);
        $query->bindParam(':email', $email, PDO::PARAM_STR);
        $query->bindParam(':ip', $ip, PDO::PARAM_STR);
        $query->bindParam(':country', $country, PDO::PARAM_STR);
        $query->bindParam(':action', $action, PDO::PARAM_STR);
        $query->bindParam(':created_date_js', $created_date_js, PDO::PARAM_STR);
        $query->bindParam(':status', $status, PDO::PARAM_STR);
        $query->execute();
    } else {
        $msg = "Your login details are invalid or email is not verified.";
        
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Login</title>

  <style>
    body, html {
      margin: 0;
      padding: 0;
      height: 100%;
      font-family: Arial, sans-serif;
    }

    /* Background image covers full page */
    body {
      background: url("images/pexels-goumbik-669610.jpg") no-repeat center center fixed;
      background-size: cover;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
    }

    /* Centered form card */
    .login-card {
      background: rgba(255, 255, 255, 0.95);
      border-radius: 12px;
      padding: 40px 30px;
      max-width: 400px;
      width: 100%;
      box-shadow: 0 8px 30px rgba(0,0,0,0.3);
      text-align: center;
      margin-bottom: 60px; /* leave space for footer */
    }

    .login-card img.logo {
      width: 120px;
      margin-bottom: 20px;
    }

    .login-card h1 {
      margin-bottom: 20px;
      font-size: 1.5rem;
      color: #0f9b75;
    }

    .login-card label {
      display: block;
      text-align: left;
      margin-bottom: 6px;
      font-weight: 600;
      color: #333;
    }

    .login-card input {
      width: 100%;
      padding: 10px 12px;
      margin-bottom: 16px;
      border: 1px solid #ccc;
      border-radius: 8px;
    }

    .login-card button {
      width: 100%;
      padding: 12px;
      background-color: #0f9b75;
      border: none;
      border-radius: 8px;
      color: #fff;
      font-weight: 600;
      cursor: pointer;
      transition: background 0.3s ease;
    }

    .login-card button:hover {
      background-color: #0a4d3e;
    }

    .foot-note {
      margin-top: 12px;
      font-size: 0.9rem;
      color: #444;
    }

    .foot-note a {
      color: #0f9b75;
      font-weight: 600;
      text-decoration: none;
    }

    /* Footer styling */
    .page-footer {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      text-align: center;
      padding: 15px;
      background: rgba(0, 0, 0, 0.5);
      color: #fff;
      font-size: 0.9rem;
    }
  </style>
</head>
<body>

  <form method="post" class="login-card">
    <!-- Logo -->
    <img src="https://test.traderssolution.com/crmvideonew/demo.png" alt="Logo" class="logo">

    <h1>Welcome Back</h1>

    <?php if (isset($msg) && $msg): ?>
      <div style="color: red; margin-bottom: 10px;"><?php echo htmlspecialchars($msg); ?></div>
    <?php endif; ?>

    <label for="login-email-input">Email</label>
    <input type="email" name="username" id="login-email-input" placeholder="you@example.com" required>

    <label for="login-password-input">Password</label>
    <input type="password" name="password" id="login-password-input" placeholder="••••••••" required>

    <button type="submit" name="signin">Sign In</button>

    <div class="foot-note">
      Don’t have an account?
      <a href="register.php">Sign up</a>
    </div>
  </form>

  <!-- Footer -->
  <footer class="page-footer">
    © <?php echo date("Y"); ?> Demo Markets. All rights reserved.
  </footer>

</body>
</html>
