<?php
session_start();
include 'config.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (empty($_SESSION['clogin'])) {
    echo "<script>window.location.href='login.php';</script>";
    exit;
}
$email = $_SESSION['clogin'];

/** Detect driver **/
$isPDO    = class_exists('PDO')    && ($conn instanceof PDO);
$isMySQLi = class_exists('mysqli') && ($conn instanceof mysqli);

/** Build query once (works for both drivers) **/
$sqlOpen = "
  SELECT ticketno, subject, priority, type, message, AdminRemark, `Date`, status
  FROM crmticket
  WHERE email = ? AND (status = 0 OR status IS NULL)
  ORDER BY `Date` DESC
";

/** Fetch rows into $rows as assoc arrays **/
$rows = [];
$debugMsg = '';
try {
    if ($isPDO) {
        $stmt = $conn->prepare($sqlOpen);
        $stmt->execute([$email]);
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $debugMsg = "Driver=PDO; rows=" . count($rows);
    } elseif ($isMySQLi) {
        $stmt = $conn->prepare($sqlOpen);
        if (!$stmt) { throw new Exception("MySQLi prepare failed: ".$conn->error); }
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $res = $stmt->get_result();
        while ($res && ($row = $res->fetch_assoc())) { $rows[] = $row; }
        $debugMsg = "Driver=MySQLi; rows=" . count($rows);
        $stmt->close();
    } else {
        throw new Exception("\$conn is neither PDO nor MySQLi");
    }
} catch (Throwable $e) {
    // Show an obvious row with the DB error so the page isn't 'blank'
    $rows = [];
    $debugMsg = "DB ERROR: " . $e->getMessage();
}
?>
<!doctype html>
<html lang="en" dir="ltr">
<head>
  <?php include 'title.php'; ?>
</head>
<body class="">
  <?php include 'header.php'; ?>
  <?php include 'side_bar.php'; ?>

  <!-- DEBUG: <?= htmlspecialchars($debugMsg, ENT_QUOTES, 'UTF-8') ?> -->
  <!-- DEBUG: email=<?= htmlspecialchars($email, ENT_QUOTES, 'UTF-8') ?> -->

  <main class="main-content">
    <div class="position-relative iq-banner"></div>

    <div class="conatiner-fluid content-inner mt-n5 py-0">
      <div class="row" style="margin-top:50px">
        <center><h4><b>Support - Open Tickets</b></h4></center>

        <div class="col-sm-12" style="margin-top:20px">
          <div class="card">
            <div class="card-body p-0">
              <div class="table-responsive mt-4">
                <table id="basic-table" class="table table-striped mb-0" role="grid">
                  <thead>
                    <tr>
                      <th>Ticket no</th>
                      <th>Subject</th>
                      <th>Priority</th>
                      <th>Issue type</th>
                      <th>Message</th>
                      <th>Remarks</th>
                      <th>Date</th>
                    </tr>
                  </thead>
                  <tbody>
                  <?php if (!empty($rows)): ?>
                    <?php foreach ($rows as $r): ?>
                      <tr>
                        <td><h6><?= htmlspecialchars($r['ticketno'] ?? '-', ENT_QUOTES, 'UTF-8') ?></h6></td>
                        <td><h6><?= htmlspecialchars($r['subject'] ?? '-', ENT_QUOTES, 'UTF-8') ?></h6></td>
                        <td><?= htmlspecialchars($r['priority'] ?? '-', ENT_QUOTES, 'UTF-8') ?></td>
                        <td><?= htmlspecialchars($r['type'] ?? '-', ENT_QUOTES, 'UTF-8') ?></td>
                        <td><?= nl2br(htmlspecialchars($r['message'] ?? '', ENT_QUOTES, 'UTF-8')) ?></td>
                        <td><?= htmlspecialchars($r['AdminRemark'] ?? '-', ENT_QUOTES, 'UTF-8') ?></td>
                        <td><?= htmlspecialchars($r['Date'] ?? '-', ENT_QUOTES, 'UTF-8') ?></td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr><td colspan="7" class="text-center text-muted py-4">
                      No open tickets found for <?= htmlspecialchars($email, ENT_QUOTES, 'UTF-8') ?>.
                    </td></tr>
                  <?php endif; ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div> <!-- col -->
      </div>   <!-- row -->
    </div>     <!-- content-inner -->
  </main>

  <?php include 'color_setting.php'; ?>

  <script src="assets/js/core/libs.min.js"></script>
  <script src="assets/js/core/external.min.js"></script>
  <script src="assets/js/charts/widgetcharts.js"></script>
  <script src="assets/js/charts/vectore-chart.js"></script>
  <script src="assets/js/charts/dashboard.js"></script>
  <script src="assets/js/plugins/fslightbox.js"></script>
  <script src="assets/js/plugins/setting.js"></script>
  <script src="assets/js/plugins/slider-tabs.js"></script>
  <script src="assets/js/plugins/form-wizard.js"></script>
  <script src="assets/vendor/aos/dist/aos.js"></script>
  <script src="assets/js/hope-ui.js" defer></script>
</body>
</html>
