<?php
@session_start();
require_once __DIR__ . '/config.php';

if (empty($_SESSION['clogin'])) {
  echo "<script>window.location.href='login.php';</script>"; exit;
}?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Performance Dashboard</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f8f9fa;
            color: #333;
        }
        .container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
        }
        .tabs {
            display: flex;
            gap: 10px;
        }
        .tab {
            padding: 10px 20px;
            background: #e67e22;
            color: #fff;
            border-radius: 5px;
            cursor: pointer;
        }
        .filters {
            display: flex;
            gap: 10px;
            margin: 20px 0;
        }
        .card-container {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
        }
        .card {
            background: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            flex: 1;
            text-align: center;
        }
        .chart-container {
            margin-top: 20px;
        }.trade-history {
            display: none;
            margin-top: 20px;
            background: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .trade-history ul {
            list-style: none;
            padding: 0;
        }
        .trade-history li {
            padding: 10px;
            border-bottom: 1px solid #ccc;
        }
    </style>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
      
    <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
      <h2>Performance</h2>
        <div class="tabs">
            <div class="tab">Summary</div>
            <div class="tab" onclick="showHistory()">History Of Trades</div>
        </div>
        <div class="filters">
            <select>
                <option>All</option>
            </select>
            <input type="date">
            <input type="date">
            <button>Submit</button>
        </div>
        <div class="card-container">
            <div class="card">Net Profit<br>0</div>
            <div class="card">Closed Orders<br>0</div>
            <div class="card">Trading Volume<br>0</div>
            <div class="card">Profit<br>0</div>
            <div class="card">Loss<br>0</div>
            <div class="card">Equity<br>2085.57</div>
        </div>
        <div class="chart-container">
            <canvas id="performanceChart"></canvas>
        </div>
    </div><br><br><br>
    </main><?php include "footer.php";?>
    </div>
    <script>
        var ctx = document.getElementById('performanceChart').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ['Net Profit', 'Closed Orders', 'Trading Volume'],
                datasets: [{
                    label: 'Performance',
                    data: [0, 0, 0],
                    backgroundColor: ['#e67e22', '#2980b9', '#27ae60']
                }]
            },
            options: {
                responsive: true,
                scales: { y: { beginAtZero: true } }
            }
        });
    </script>
</body>
</html>
