<?php
if (isset($_GET['status'])) {
    $status = $_GET['status'];
    if ($status == 'accepted') {
        echo '<div class="bg-green-500 text-white p-2 rounded-lg mb-4">Document successfully accepted!</div>';
    } elseif ($status == 'rejected') {
        echo '<div class="bg-red-500 text-white p-2 rounded-lg mb-4">Document successfully rejected!</div>';
    } elseif ($status == 'error') {
        echo '<div class="bg-yellow-500 text-white p-2 rounded-lg mb-4">There was an error processing the document!</div>';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Document List</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
        }
        .modal-content {
            background: white;
            margin: 15% auto;
            padding: 20px;
            border-radius: 8px;
            width: 50%;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            text-align: left;
        }
        .close {
            float: right;
            font-size: 24px;
            cursor: pointer;
        }
    </style>
     <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; }
        .dashboard { max-width: 1200px; margin: 20px auto; background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        .tabs { display: flex; flex-wrap: wrap; gap: 10px; }
        .tab { padding: 10px 15px; background: #ff6b00; color: white; border: none; cursor: pointer; border-radius: 5px; font-weight: bold; }
        .tab:not(.active) { background: #ccc; }
        .stats { display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 10px; padding: 20px; background: #f8f8f8; margin-bottom: 10px; text-align: center; }
        .stat-box { font-size: 18px; font-weight: bold; }
        .stat-box span { display: block; font-size: 14px; color: gray; }
        .table-container { overflow-x: auto; }
        table { width: 100%; border-collapse: collapse; background: white; }
        th, td { padding: 10px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background: #ff6b00; color: white; }
    </style>
</head>

<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>
        
        <!-- Main Content -->
               <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
     <input type="text" id="search" placeholder="Search..." class="p-2 border border-gray-300 rounded-lg w-1/3" oninput="filterTable()">
               

            <!-- Table Section -->
            <div class="container mx-auto p-6">
                <h2 class="text-2xl font-bold text-gray-700 mb-4">User Document List</h2>

                <table class="min-w-full bg-white border border-gray-300 rounded-md">
                    <thead>
                        <tr>
                            <th class="p-4 border-b">ID</th>
                            <th class="p-4 border-b">User Name</th>
                            <th class="p-4 border-b">Email</th>
                            <th class="p-4 border-b">Document Type</th>
                            <th class="p-4 border-b">Country</th>
                            <th class="p-4 border-b">Date Submitted</th>
                            <th class="p-4 border-b">Actions</th>
                        </tr>
                    </thead>
                    <tbody id="table-body">
                        <tr>
                            <td class="p-4">1</td>
                            <td class="p-4">John Doe</td>
                            <td class="p-4">john@example.com</td>
                            <td class="p-4">Passport</td>
                            <td class="p-4">USA</td>
                            <td class="p-4">2025-02-01</td>
                            <td class="p-4">
                                <button class="text-blue-600 view-details" data-id="1">View Details</button>
                            </td>
                        </tr>
                        <tr>
                            <td class="p-4">2</td>
                            <td class="p-4">Jane Smith</td>
                            <td class="p-4">jane@example.com</td>
                            <td class="p-4">Driving License</td>
                            <td class="p-4">Canada</td>
                            <td class="p-4">2025-02-02</td>
                            <td class="p-4">
                                <button class="text-blue-600 view-details" data-id="2">View Details</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </main>
    </div>

    <!-- Modal Popup -->
    <div id="detailModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Document Details</h2>
            <p id="modalContent">Loading...</p>
        </div>
    </div>

    <!-- Footer -->
    <?php include "footer.php";?>

    <script>
        // Function to filter the table based on the search input
        function filterTable() {
            const searchInput = document.getElementById("search").value.toLowerCase();
            const tableRows = document.querySelectorAll("#table-body tr");

            tableRows.forEach(row => {
                const cells = row.querySelectorAll("td");
                let match = false;
                cells.forEach(cell => {
                    if (cell.textContent.toLowerCase().includes(searchInput)) {
                        match = true;
                    }
                });
                row.style.display = match ? "" : "none";
            });
        }

        // Modal functionality
        $(document).ready(function() {
            $('.view-details').on('click', function() {
                let docId = $(this).data('id');
                $('#modalContent').text(`Fetching details for document ID: ${docId}...`);
                $('#detailModal').fadeIn();
            });
            
            $('.close').on('click', function() {
                $('#detailModal').fadeOut();
            });
        });
    </script>
</body>
</html>
