<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wallet to MT5 Transfer</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            text-align: center;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 400px;
            margin: 50px auto;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            margin-bottom: 20px;
            color: #333;
        }
        label {
            display: block;
            font-weight: bold;
            margin: 10px 0 5px;
            text-align: left;
        }
        select, input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            margin-bottom: 15px;
            font-size: 16px;
        }
        .btn {
            width: 100%;
            padding: 10px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 18px;
            cursor: pointer;
        }
        .btn:hover {
            background: #0056b3;
        }
    </style>
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

       <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
       <h2>Transfer from Wallet to MT5</h2>
        <form id="transferForm">
            <label for="mt5Account">Select MT5 Account</label>
            <select id="mt5Account" required>
                <option value="100001">100001</option>
                <option value="100002">100002</option>
                <option value="100003">100003</option>
            </select>
            
            <label for="amount">Amount</label>
            <input type="number" id="amount" placeholder="Enter amount" required>
            
            <button type="submit" class="btn bg-[#CD7F32]">Transfer</button>
        </form>
    </div><br><br></main><?php include "footer.php";?></div>
    
    <script>
        $(document).ready(function() {
            $('#transferForm').on('submit', function(event) {
                event.preventDefault();
                alert('Funds transferred successfully!');
            });
        });
    </script>
</body>
</html>
