<?php
session_start();
error_reporting(E_ALL);
include('config.php');

// Pagination setup
$records_per_page = 10;
$current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($current_page - 1) * $records_per_page;

$total_records_sql = "SELECT COUNT(*) FROM wallet_withdraw";
$total_records_query = $conn->prepare($total_records_sql);
$total_records_query->execute();
$total_records = $total_records_query->fetchColumn();
$total_pages = ceil($total_records / $records_per_page);

$status = "1";
$sql = "SELECT * FROM wallet_withdraw WHERE status = :status ORDER BY withdraw_date DESC LIMIT :offset, :records_per_page";
$query = $conn->prepare($sql);
$query->bindParam(':status', $status, PDO::PARAM_STR);
$query->bindParam(':offset', $offset, PDO::PARAM_INT);
$query->bindParam(':records_per_page', $records_per_page, PDO::PARAM_INT);
$query->execute();
$results = $query->fetchAll(PDO::FETCH_OBJ);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Wallet Withdraw History</title>
<script src="https://cdn.tailwindcss.com"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

<style>
    .glass-card {
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
    }
    .badge { @apply inline-flex items-center gap-1 px-2 py-1 text-xs font-semibold rounded; }
    .badge-success { @apply bg-green-500 text-white; }
    .badge-danger { @apply bg-red-500 text-white; }
    .badge-primary { @apply bg-blue-500 text-white; }
    tr:hover {
    background-color: rgba(200, 200, 200, 0.2); /* light gray hover */
}
</style>
</head>
<body class="bg-gray-100">

<?php include('header.php'); ?>

<div class="flex flex-col md:flex-row">
    <?php include("side_bar.php"); ?>

    <main class="flex-1 p-6 md:ml-64">
        <div class="glass-card rounded-xl shadow-2xl p-6">
            <!-- Header -->
            <div class="flex flex-col md:flex-row justify-between items-center mb-6">
                <h2 class="text-2xl font-bold bg-gradient-to-r from-cyan-400 to-blue-500 text-transparent bg-clip-text">
                    <i class="fas fa-wallet"></i> Wallet Withdraw History
                </h2>
                <a href="dashboard.php" class="px-5 py-2 bg-gradient-to-r from-orange-500 to-pink-500 rounded-lg shadow-lg hover:scale-105 transition-transform">
                    <i class="fas fa-arrow-left"></i> Back to Dashboard
                </a>
            </div>

            <!-- Table -->
            <div class="overflow-x-auto rounded-lg border border-gray-700">
                <table class="min-w-full text-sm">
                    <thead class="bg-gradient-to-r from-gray-800 to-gray-700 text-gray-300 uppercase text-xs">
                        <tr>
                            <th class="px-4 py-3 text-left">Email</th>
                            <th class="px-4 py-3 text-left">Amount</th>
                            <th class="px-4 py-3 text-left">Payment Mode</th>
                            <th class="px-4 py-3 text-left">Withdraw Date</th>
                            <th class="px-4 py-3 text-left">Status</th>
                            <th class="px-4 py-3 text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if ($query->rowCount() > 0) {
                            foreach ($results as $result) {
                                $stats = $result->Status;
                                $view_link = ($result->withdraw_type == "crypto" || $result->withdraw_type == "usdttrc") 
                                    ? "view_withdrawal1.php" 
                                    : "view_withdrawal.php";
                                ?>
                                <tr class="border-b border-gray-700 hover:bg-gray-300 transition">
                                    <td class="px-4 py-3"><?= htmlentities($result->email) ?></td>
                                    <td class="px-4 py-3 text-green-400 font-semibold">$<?= htmlentities($result->withdraw_amount) ?></td>
                                    <td class="px-4 py-3 capitalize"><?= htmlentities($result->withdraw_type) ?></td>
                                    <td class="px-4 py-3"><?= htmlentities($result->withdraw_date) ?></td>
                                    <td class="px-4 py-3">
                                        <?php if ($stats == 1): ?>
                                            <span class="badge badge-success"><i class="fas fa-check-circle"></i> Success</span>
                                        <?php elseif ($stats == 2): ?>
                                            <span class="badge badge-danger"><i class="fas fa-times-circle"></i> Cancelled</span>
                                        <?php else: ?>
                                            <span class="badge badge-primary"><i class="fas fa-hourglass-half"></i> Pending</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <a href="<?= $view_link; ?>?id=<?= htmlentities($result->id); ?>&email=<?= htmlentities($result->email); ?>&withdraw=<?= htmlentities($result->withdraw_amount); ?>"
                                           class="px-4 py-2 bg-gradient-to-r from-gray-700 to-gray-600 rounded-lg hover:from-blue-600 hover:to-blue-500 transition text-white text-xs font-semibold shadow-lg">
                                           <i class="fas fa-eye"></i> View
                                        </a>
                                    </td>
                                </tr>
                            <?php
                            }
                        } else {
                            echo '<tr><td colspan="6" class="px-4 py-6 text-center text-gray-400">No withdrawal records found.</td></tr>';
                        }
                        ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-6 flex justify-center">
                <ul class="flex gap-2">
                    <?php
                    if ($current_page > 1) {
                        echo '<li><a class="px-3 py-1 rounded bg-gray-700 hover:bg-gray-600" href="?page='.($current_page - 1).'">Prev</a></li>';
                    }
                    for ($i = 1; $i <= $total_pages; $i++) {
                        $active = ($i == $current_page) ? 'bg-blue-600' : 'bg-gray-700 hover:bg-gray-600';
                        echo '<li><a class="px-3 py-1 rounded '.$active.'" href="?page='.$i.'">'.$i.'</a></li>';
                    }
                    if ($current_page < $total_pages) {
                        echo '<li><a class="px-3 py-1 rounded bg-gray-700 hover:bg-gray-600" href="?page='.($current_page + 1).'">Next</a></li>';
                    }
                    ?>
                </ul>
            </div>
        </div>
    </main>
</div>

<?php include('footer.php'); ?>

</body>
</html>
