<?php
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES["csv_file"])) {
    $file = $_FILES["csv_file"]["tmp_name"];

    if (($handle = fopen($file, "r")) !== FALSE) {
        $rows = [];
        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            $rows[] = $data; // Store CSV rows in an array
        }
        fclose($handle);
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bulk Withdrawal Upload</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <?php include "header.php"; ?>

    <div class="flex h-screen">
        <?php include "side_bar.php"; ?>

     <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container"> 
     <h1 class="text-4xl font-bold text-center text-[#CD7F32] mb-6">Bulk Withdrawal Upload</h1>

    <!-- Upload CSV Form -->
    <form action="bulk_upload.php" method="POST" enctype="multipart/form-data" class="max-w-lg mx-auto bg-white p-8 rounded-lg shadow-lg">
        <label for="csv_file" class="block text-lg font-semibold text-gray-700 mb-4">Upload CSV File:</label>
        <input type="file" id="csv_file" name="csv_file" accept=".csv" required class="w-full px-4 py-3 border border-gray-300 rounded-md mb-6 text-gray-800 focus:outline-none focus:ring-2 focus:ring-[#CD7F32]">
        <button type="submit" class="w-full py-3 bg-[#CD7F32] text-white font-bold rounded-md shadow-md hover:bg-[#B36F2B] transition duration-300">
            Upload & Preview
        </button>
    </form>

    <!-- Preview Table -->
    <?php if (!empty($rows)): ?>
        <div class="mt-10 bg-white p-8 rounded-lg shadow-lg">
            <h2 class="text-2xl font-semibold text-[#CD7F32] mb-6">Preview Data</h2>
            <table class="w-full border-collapse border border-gray-300 rounded-lg">
                <thead>
                    <tr class="bg-[#CD7F32] text-white">
                        <th class="border border-gray-300 p-3 text-left">Client ID</th>
                        <th class="border border-gray-300 p-3 text-left">MT5 ID</th>
                        <th class="border border-gray-300 p-3 text-left">Amount</th>
                        <th class="border border-gray-300 p-3 text-left">Comment</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($rows as $index => $row): ?>
                        <?php if ($index > 0): // Skip header row ?>
                            <tr class="hover:bg-gray-50">
                                <td class="border border-gray-300 p-3"><?php echo htmlspecialchars($row[0]); ?></td>
                                <td class="border border-gray-300 p-3"><?php echo htmlspecialchars($row[1]); ?></td>
                                <td class="border border-gray-300 p-3">$<?php echo htmlspecialchars($row[2]); ?></td>
                                <td class="border border-gray-300 p-3"><?php echo htmlspecialchars($row[3]); ?></td>
                            </tr>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <!-- Process Withdrawals Button -->
            <form action="process_withdrawals.php" method="POST">
                <input type="hidden" name="data" value="<?php echo base64_encode(json_encode($rows)); ?>">
                <button type="submit" class="w-full mt-6 py-3 bg-[#CD7F32] text-white font-bold rounded-md shadow-md hover:bg-[#B36F2B] transition duration-300">
                    Process Withdrawals
                </button>
            </form>
        </div>
    <?php endif; ?>
</div>

           
        </main> <?php include "footer.php"; ?>
    </div>
</body>
</html>
