<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload User Documents</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>
        <?php //include "header.php";?>
        <!-- Main Content -->
          <main class="flex-1 p-6 md:ml-64">
            <div class="container">
               <h2 class="text-2xl font-bold text-gray-700 mb-4">Upload User Documents</h2>

                <form action="upload_document.php" method="POST" enctype="multipart/form-data" class="bg-white p-6 rounded-lg shadow-md w-full max-w-4xl">
                    <!-- User Selection -->
                    <div class="mb-4">
                        <label for="user" class="block text-gray-700">Select User:</label>
                        <select id="user" name="user" class="w-full p-2 border border-gray-300 rounded-md" required>
                            <!-- Populate this with users from the database -->
                            <option value="">Select a User</option>
                            <option value="1">John Doe</option>
                            <option value="2">Jane Smith</option>
                            <!-- Add more users dynamically from your database -->
                        </select>
                    </div>

                    <!-- Proof of Identity -->
                    <div class="mb-4">
                        <label for="identity_proof" class="block text-gray-700">Proof of Identity:</label>
                        <input type="file" id="identity_proof" name="identity_proof" accept="image/*,application/pdf" required class="w-full p-2 border border-gray-300 rounded-md">
                    </div>

                    <!-- Proof of Address -->
                    <div class="mb-4">
                        <label for="address_proof" class="block text-gray-700">Proof of Address:</label>
                        <input type="file" id="address_proof" name="address_proof" accept="image/*,application/pdf" required class="w-full p-2 border border-gray-300 rounded-md">
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" class="bg-[#CD7F32] text-white px-6 py-2 rounded-md">Upload Documents</button>
                </form>
            </div>
        </main><?php include "footer.php";?>
    </div>

    <!-- Footer -->
    <?php //include "footer.php";?>

</body>
</html>
