<?php
session_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);
include "config.php"; // Ensure this file connects to your database

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}


?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cash Deposit</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>
<main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
   <div class="container">
      <div class="container mx-auto">
                <h1 class="text-4xl font-bold text-center mb-6 text-[#CD7F32]">Cash Deposit</h1>

                <!-- Deposit Form -->
                <form action="add_cash_deposit.php" method="POST" class="max-w-3xl mx-auto bg-white p-10 rounded-lg shadow-xl border border-gray-200">
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Amount -->
                        <div>
                            <label for="amount" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Deposit Amount:</label>
                            <input type="number" id="amount" name="amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter deposit amount" min="1">
                        </div>

                        <!-- Comment -->
                        <div>
                            <label for="comment" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Comment:</label>
                            <textarea id="comment" name="comment" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" rows="4" placeholder="Optional comment"></textarea>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="mt-8 text-center">
                        <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                            Add Cash Deposit
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </main>    <?php include "footer.php";?>

</div>
</body>
</html>
