<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include "config.php";

// Check if user is logged in
if (strlen($_SESSION['clogin']) == 0) {
    header("Location: login.php");
    exit();
}

// Get user email from session
$email = $_SESSION['clogin'];

// Fetch user's MT5 accounts
$stmt = $conn->prepare("SELECT trade_id FROM liveaccount WHERE email = ?");
$stmt->execute([$email]);
$mt5Accounts = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Process form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $deposit_type = $_POST['deposit_type'];
    $deposit_amount = $_POST['deposit_amount'];
    $trade_id = $_POST['trade_id'];
    
    // Common fields
    $data = [
        'email' => $email,
        'trade_id' => $trade_id,
        'deposit_amount' => $deposit_amount,
        'deposit_type' => $deposit_type,
        'Status' => 0,
        'deposted_date' => date('Y-m-d H:i:s')
    ];
    
    // Handle different deposit types
    switch ($deposit_type) {
        case 'Bank Transfer':
            $data['company_bank'] = $_POST['company_bank'];
            $data['client_bank'] = $_POST['client_bank'];
            $data['account_number'] = $_POST['account_number'];
            $data['ifsc'] = $_POST['ifsc'];
            $data['utr_number'] = $_POST['utr_number'];
            break;
            
        case 'USDT':
        case 'Bitcoin':
            $data['btc_amount'] = $_POST['crypto_amount'];
            $data['utr_number'] = $_POST['transaction_hash'];
            break;
            
        case 'PayPal':
        case 'Neteller':
            $data['utr_number'] = $_POST['transaction_id'];
            break;
    }
    
    // Handle file upload for all deposit types
    if ($_FILES['receipt']['name']) {
        $target_dir = "docs/";
        if (!file_exists($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $target_file = $target_dir . basename($_FILES["receipt"]["name"]);
        if (move_uploaded_file($_FILES["receipt"]["tmp_name"], $target_file)) {
            $data['image'] = basename($_FILES["receipt"]["name"]);
        }
    }
    
    // Insert into database
    $columns = implode(", ", array_keys($data));
    $placeholders = ":" . implode(", :", array_keys($data));
    
    $sql = "INSERT INTO wallet_deposit ($columns) VALUES ($placeholders)";
    $query = $conn->prepare($sql);
    
    foreach ($data as $key => $value) {
        $query->bindValue(":$key", $value);
    }
    
    if ($query->execute()) {
        $success = "Deposit request submitted successfully! Your Trade ID: $trade_id";
    } else {
        $error = "Error: " . implode(" ", $query->errorInfo());
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deposit Page</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: #fff;
            margin: 0;
            padding: 0;
            color: #333;
        }

        .flex {
            display: flex;
        }

        .flex-col {
            flex-direction: column;
        }

        .md\:flex-row {
            flex-direction: row;
        }

        .h-screen {
            height: 100vh;
        }

        .p-6 {
            padding: 1.5rem;
        }

        .md\:ml-64 {
            margin-left: 16rem;
        }

        .welcome-section {
            padding: 40px;
            background: linear-gradient(135deg, #E97451, #8B5A2B);
            color: white;
            border-radius: 12px;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
        }

        .deposit-methods {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 25px;
            margin-top: 30px;
        }

        .deposit-method {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            width: 220px;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 8px;
            background-color: white;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .deposit-method:hover {
            transform: translateY(-5px);
            box-shadow: 0px 8px 20px rgba(0, 0, 0, 0.2);
        }

        .method-logo {
            width: 80px;
            height: 80px;
            object-fit: contain;
            display: block;
            margin: 0 auto;
        }

        .deposit-btn {
            background: #E97451;
            color: white;
            border: none;
            padding: 10px 15px;
            font-size: 14px;
            border-radius: 5px;
            transition: background 0.3s ease, transform 0.2s;
            cursor: pointer;
        }

        .deposit-btn:hover {
            background: #8B5A2B;
            transform: scale(1.05);
        }

        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
        }

        .modal-content {
            background-color: #fff;
            margin: 10% auto;
            padding: 30px;
            border-radius: 10px;
            width: 80%;
            max-width: 600px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.3);
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
        }

        .form-group input, 
        .form-group select, 
        .form-group textarea {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
        }

        .submit-btn {
            background: #E97451;
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
        }

        .submit-btn:hover {
            background: #8B5A2B;
        }

        @media (max-width: 768px) {
            .md\:ml-64 {
                margin-left: 0;
            }
            .deposit-method {
                width: 100%;
            }
            .modal-content {
                width: 90%;
            }
        }

        .trade-id-select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
            margin-bottom: 20px;
            background-color: white;
        }

        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
        }

        .alert-danger {
            background: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
<div class="flex flex-col md:flex-row h-screen">
    <!-- Sidebar -->
    <?php include "side_bar.php";?>

    <!-- Main Content -->
    <main class="flex-1 p-6 md:ml-64" style="width:100%;">
        <!-- Messages -->
        <?php if (isset($success)): ?>
            <div class="alert alert-success">
                <?php echo htmlspecialchars($success); ?>
            </div>
        <?php endif; ?>
        
        <?php if (isset($error)): ?>
            <div class="alert alert-danger">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>
        
        <div class="welcome-section">
            <h1>🚀 Fast & Secure Deposits</h1>
            <p>Choose your preferred method and fund your account instantly!</p>
        </div>

        <div class="deposit-methods">
            <!-- Bank Deposit -->
            <div class="deposit-method" onclick="openModal('bank')">
                <img src="images/banks.jpg" alt="Bank" class="method-logo">
                <h3>Bank Transfer</h3>
                <p>Secure wire transfers</p>
                <button class="deposit-btn">Deposit Now</button>
            </div>

            <!-- USDT Deposit -->
            <div class="deposit-method" onclick="openModal('usdt')">
                <img src="images/usdttrc20.png" alt="USDT" class="method-logo">
                <h3>USDT</h3>
                <p>Instant Crypto Transactions</p>
                <button class="deposit-btn">Deposit Now</button>
            </div>

            <!-- PayPal Deposit -->
            <div class="deposit-method" onclick="openModal('paypal')">
                <img src="images/paypal-removebg-preview.png" alt="PayPal" class="method-logo">
                <h3>PayPal</h3>
                <p>Easy Online Payments</p>
                <button class="deposit-btn">Deposit Now</button>
            </div>
            
            <!-- Neteller Deposit -->
            <div class="deposit-method" onclick="openModal('neteller')">
                <img src="images/neteller.png" alt="Neteller" class="method-logo">
                <h3>Neteller</h3>
                <p>Fast e-wallet transfers</p>
                <button class="deposit-btn">Deposit Now</button>
            </div>
            
            <!-- Bitcoin Deposit -->
            <div class="deposit-method" onclick="openModal('bitcoin')">
                <img src="images/bitcoin.png" alt="Bitcoin" class="method-logo">
                <h3>Bitcoin</h3>
                <p>Decentralized & Secure</p>
                <button class="deposit-btn">Deposit Now</button>
            </div>
        </div>

        <!-- Bank Transfer Modal -->
        <div id="bankModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeModal('bankModal')">&times;</span>
                <h2>Bank Transfer Deposit</h2>
                <form method="post" enctype="multipart/form-data">
                    <input type="hidden" name="deposit_type" value="Bank Transfer">
                    
                    <div class="form-group">
                        <label for="trade_id">Select Trading Account</label>
                        <select id="trade_id" name="trade_id" class="trade-id-select" required>
                            <option value="" disabled selected>-- Select Trading Account --</option>
                            <?php foreach ($mt5Accounts as $account): ?>
                                <option value="<?= htmlspecialchars($account) ?>"><?= htmlspecialchars($account) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="deposit_amount">Deposit Amount (USD)</label>
                        <input type="number" id="deposit_amount" name="deposit_amount" min="10" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="company_bank">Our Bank Name</label>
                        <select id="company_bank" name="company_bank" required>
                            <option value="">Select Bank</option>
                            <option value="Example Bank">Example Bank</option>
                            <option value="Another Bank">Another Bank</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="client_bank">Your Bank Name</label>
                        <input type="text" id="client_bank" name="client_bank" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="account_number">Your Account Number</label>
                        <input type="text" id="account_number" name="account_number" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="ifsc">IFSC Code</label>
                        <input type="text" id="ifsc" name="ifsc" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="utr_number">UTR/Transaction Number</label>
                        <input type="text" id="utr_number" name="utr_number" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="receipt">Upload Payment Receipt</label>
                        <input type="file" id="receipt" name="receipt" accept="image/*" required>
                    </div>
                    
                    <button type="submit" class="submit-btn">Submit Deposit Request</button>
                </form>
            </div>
        </div>

        <!-- USDT Modal -->
        <div id="usdtModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeModal('usdtModal')">&times;</span>
                <h2>USDT Deposit</h2>
                <form method="post" enctype="multipart/form-data">
                    <input type="hidden" name="deposit_type" value="USDT">
                    
                    <div class="form-group">
                        <label for="trade_id">Select Trading Account</label>
                        <select id="trade_id" name="trade_id" class="trade-id-select" required>
                            <option value="" disabled selected>-- Select Trading Account --</option>
                            <?php foreach ($mt5Accounts as $account): ?>
                                <option value="<?= htmlspecialchars($account) ?>"><?= htmlspecialchars($account) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="deposit_amount">Deposit Amount (USD)</label>
                        <input type="number" id="deposit_amount" name="deposit_amount" min="10" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="crypto_amount">USDT Amount</label>
                        <input type="text" id="crypto_amount" name="crypto_amount" placeholder="Will be calculated automatically" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label for="transaction_hash">Transaction Hash</label>
                        <input type="text" id="transaction_hash" name="transaction_hash" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="receipt">Upload Transaction Proof</label>
                        <input type="file" id="receipt" name="receipt" accept="image/*" required>
                    </div>
                    
                    <button type="submit" class="submit-btn">Submit Deposit Request</button>
                </form>
            </div>
        </div>

        <!-- PayPal Modal -->
        <div id="paypalModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeModal('paypalModal')">&times;</span>
                <h2>PayPal Deposit</h2>
                <form method="post" enctype="multipart/form-data">
                    <input type="hidden" name="deposit_type" value="PayPal">
                    
                    <div class="form-group">
                        <label for="trade_id">Select Trading Account</label>
                        <select id="trade_id" name="trade_id" class="trade-id-select" required>
                            <option value="" disabled selected>-- Select Trading Account --</option>
                            <?php foreach ($mt5Accounts as $account): ?>
                                <option value="<?= htmlspecialchars($account) ?>"><?= htmlspecialchars($account) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="deposit_amount">Deposit Amount (USD)</label>
                        <input type="number" id="deposit_amount" name="deposit_amount" min="10" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="transaction_id">PayPal Transaction ID</label>
                        <input type="text" id="transaction_id" name="transaction_id" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="receipt">Upload Payment Receipt</label>
                        <input type="file" id="receipt" name="receipt" accept="image/*" required>
                    </div>
                    
                    <button type="submit" class="submit-btn">Submit Deposit Request</button>
                </form>
            </div>
        </div>

        <!-- Neteller Modal -->
        <div id="netellerModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeModal('netellerModal')">&times;</span>
                <h2>Neteller Deposit</h2>
                <form method="post" enctype="multipart/form-data">
                    <input type="hidden" name="deposit_type" value="Neteller">
                    
                    <div class="form-group">
                        <label for="trade_id">Select Trading Account</label>
                        <select id="trade_id" name="trade_id" class="trade-id-select" required>
                            <option value="" disabled selected>-- Select Trading Account --</option>
                            <?php foreach ($mt5Accounts as $account): ?>
                                <option value="<?= htmlspecialchars($account) ?>"><?= htmlspecialchars($account) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="deposit_amount">Deposit Amount (USD)</label>
                        <input type="number" id="deposit_amount" name="deposit_amount" min="10" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="transaction_id">Neteller Transaction ID</label>
                        <input type="text" id="transaction_id" name="transaction_id" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="receipt">Upload Payment Receipt</label>
                        <input type="file" id="receipt" name="receipt" accept="image/*" required>
                    </div>
                    
                    <button type="submit" class="submit-btn">Submit Deposit Request</button>
                </form>
            </div>
        </div>

        <!-- Bitcoin Modal -->
        <div id="bitcoinModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeModal('bitcoinModal')">&times;</span>
                <h2>Bitcoin Deposit</h2>
                <form method="post" enctype="multipart/form-data">
                    <input type="hidden" name="deposit_type" value="Bitcoin">
                    
                    <div class="form-group">
                        <label for="trade_id">Select Trading Account</label>
                        <select id="trade_id" name="trade_id" class="trade-id-select" required>
                            <option value="" disabled selected>-- Select Trading Account --</option>
                            <?php foreach ($mt5Accounts as $account): ?>
                                <option value="<?= htmlspecialchars($account) ?>"><?= htmlspecialchars($account) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="deposit_amount">Deposit Amount (USD)</label>
                        <input type="number" id="deposit_amount" name="deposit_amount" min="10" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="crypto_amount">Bitcoin Amount</label>
                        <input type="text" id="crypto_amount" name="crypto_amount" placeholder="Will be calculated automatically" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label for="transaction_hash">Transaction Hash</label>
                        <input type="text" id="transaction_hash" name="transaction_hash" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="receipt">Upload Transaction Proof</label>
                        <input type="file" id="receipt" name="receipt" accept="image/*" required>
                    </div>
                    
                    <button type="submit" class="submit-btn">Submit Deposit Request</button>
                </form>
            </div>
        </div><?php include "footer.php"; ?>
    </main>
</div>



<script>
    // Modal functionality
    function openModal(type) {
        document.getElementById(type + 'Modal').style.display = 'block';
    }
    
    function closeModal(type) {
        document.getElementById(type).style.display = 'none';
    }
    
    // Close modal when clicking outside
    window.onclick = function(event) {
        if (event.target.className === 'modal') {
            event.target.style.display = 'none';
        }
    }
    
    // Auto-calculate crypto amount based on USD amount
    document.querySelectorAll('input[name="deposit_amount"]').forEach(input => {
        input.addEventListener('input', function() {
            const usdAmount = parseFloat(this.value);
            if (!isNaN(usdAmount)) {
                const form = this.closest('form');
                const depositType = form.querySelector('input[name="deposit_type"]').value;
                
                let rate = 1;
                if (depositType === 'USDT') {
                    rate = 1; // 1 USDT = 1 USD
                } else if (depositType === 'Bitcoin') {
                    rate = 0.000025; // Example rate - 1 BTC = 40,000 USD
                }
                
                const cryptoAmount = usdAmount * rate;
                const cryptoField = form.querySelector('input[name="crypto_amount"]');
                if (cryptoField) {
                    cryptoField.value = cryptoAmount.toFixed(8);
                }
            }
        });
    });
    
    // Auto-select trade_id if only one account exists
    document.addEventListener('DOMContentLoaded', function() {
        const tradeSelects = document.querySelectorAll('select[name="trade_id"]');
        if (tradeSelects.length > 0 && <?= count($mt5Accounts) ?> === 1) {
            tradeSelects.forEach(select => {
                select.value = "<?= htmlspecialchars($mt5Accounts[0] ?? '') ?>";
            });
        }
    });
</script>
</body>
</html>