<?php
session_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);
include "config.php"; // Ensure this file connects to your database

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}


?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
            color: #333;
        }
        .container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
        }
         
        .dashboards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
        }
      .dashboard {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
        }
        .card {
            background: white;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        } .cards {
            background: black;
            padding: 10px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        .stats {
            display: flex;
            justify-content: center;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
            margin: 20px 0;
        }
        .stat-item {
            background: white;
            padding: 15px;
            border-radius: 10px;
            text-align: center;
            font-weight: bold;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
            min-width: 150px;
        } .state {
            display: flex;
            justify-content: center;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
            margin: 20px 0;
        }
        .state-item {
            background: white;
            padding: 15px;
            border-radius: 10px;
            text-align: center;
            font-weight: bold;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
            min-width: 150px;
        }
        .table-section {
            overflow-x: auto;
            display: flex;
            background-color:white;
            justify-content: space-between;
            align-items: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: center;
        }
        th {
            background-color: #f1f1f1;
        }
        .referral-section {
            width: 25%;
        }
        .referral-button {
            display: inline-block;
            padding: 5px 10px;
            background-color: #ff7b00;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-size:10px;
            transition: 0.3s;
        }
        .referral-button:hover {
            background-color: #e66900;
        }
        canvas {
            align:center;
            max-width: 200px;
            max-height: 200px;
        }
    </style>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container mx-auto">
        <div class="dashboard">
            <div class="card">
                <h3>Monthly Commission</h3>
                <canvas id="commissionChart"></canvas>
            </div>
            <div class="card">
                <h3>My Client Transaction</h3>
                <canvas id="clientTransactionChart"></canvas>
            </div>
        </div>
        <div class="stats">
            <div class="stat-item">$80 Withdraw Commission</div>
            <div class="stat-item">$260 Available Commission</div>
            <div class="stat-item">77.6 Total Volume</div>
            <div class="stat-item">23 Total Clients</div>
        </div>
        <div class="dashboards">
            <div class="card">
                <h3>KYC</h3>
                <canvas id="kycChart"></canvas>
            </div>
            <div class="card">
                <h3>Live Account</h3>
                <canvas id="liveAccountChart"></canvas>
            </div>
            <div class="card">
                <h3>FTD</h3>
                <canvas id="ftdChart"></canvas>
            </div>
            <div class="card">
                <h3>Active Traders & Sub IB</h3>
                <canvas id="activeTradersChart"></canvas>
            </div>
        </div>
        
            <div class="state">
            <div class="state-item">26.2<br><p>Lot</p></div>
            <div class="state-item">$152.7<br><p>Commission</p></div>
            <div class="state-item">$12345<br><p>Deposit</p></div>
            <div class="state-item">$56778<br><p>Withdraw</p></div>
            <div class="state-item">
                <h3>Copy your Referral Link!</h3>
                <a href="#" class="referral-button">Click Here</a>
            </div>
        </div>
        
        <div class="table-section">
            
            
            <div class="cards" style="width: 100%">
                <h3>Top 5 Earnings of Sub IBs</h3>
                <table class="bg-white-500">
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Total Lots</th>
                        <th>Commission Earned</th>
                    </tr>
                    <tr>
                        <td>1</td>
                        <td>Techysquad</td>
                        <td>info@techysquad.com</td>
                        <td>26.2</td>
                        <td>157.2</td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td>Dev TS</td>
                        <td>patelsinol@gmail.com</td>
                        <td>28.6</td>
                        <td>114.4</td>
                    </tr>
                    <tr>
                        <td>3</td>
                        <td>Dev Account</td>
                        <td>patelsinol@gmail.com</td>
                        <td>22.8</td>
                        <td>68.4</td>
                    </tr>
                </table>
            </div>
        </div>
    </div><br><br><br>
    </main>
    <?php include "footer.php";?>
    <script>
        const createChart = (id, type, labels, data, colors) => {
            new Chart(document.getElementById(id), {
                type: type,
                data: {
                    labels: labels,
                    datasets: [{ data: data, backgroundColor: colors }]
                }
            });
        };

        createChart('commissionChart', 'bar', ['Commission'], [1], ['orange']);
        createChart('clientTransactionChart', 'doughnut', ['Total Deposit', 'Total Withdraw'], [60, 40], ['#ff6b6b', '#4CAF50']);
        createChart('kycChart', 'pie', ['Complete', 'Pending'], [70, 30], ['#4CAF50', '#ff6b6b']);
        createChart('liveAccountChart', 'pie', ['Complete', 'Pending'], [50, 50], ['#4CAF50', '#ff6b6b']);
        createChart('ftdChart', 'pie', ['Complete', 'Pending'], [80, 20], ['#4CAF50', '#ff6b6b']);
        createChart('activeTradersChart', 'pie', ['Traders', 'Sub IB'], [65, 35], ['#4CAF50', '#ff6b6b']);
    </script>
</body>
</html>
