<?php
session_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);
include "config.php"; // Ensure this file connects to your database

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}



// Get parameters for filtering and pagination
$per_page = isset($_GET['per_page']) ? (int)$_GET['per_page'] : 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page - 1) * $per_page;

$date_filter = isset($_GET['date_filter']) ? $_GET['date_filter'] : '';
$search = isset($_GET['search']) ? $_GET['search'] : '';

// Build the query with filtering
$query = "SELECT * FROM ibuser_commissions WHERE 1"; // Default query to fetch all commissions

// Add date filter
if ($date_filter) {
    $query .= " AND date = :date_filter";
}

// Add search filter (order_id or symbol)
if ($search) {
    $query .= " AND (order_id LIKE :search OR symbol LIKE :search)";
}

// Add pagination
$query .= " LIMIT :start, :per_page";

// Prepare and execute the query
$stmt = $conn->prepare($query);

if ($date_filter) {
    $stmt->bindValue(':date_filter', $date_filter);
}
if ($search) {
    $stmt->bindValue(':search', '%' . $search . '%');
}

$stmt->bindValue(':start', $start, PDO::PARAM_INT);
$stmt->bindValue(':per_page', $per_page, PDO::PARAM_INT);

$stmt->execute();

// Fetch results
$commissions = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get the total number of commissions for pagination
$total_commissions_stmt = $conn->prepare("SELECT COUNT(*) FROM ibuser_commissions WHERE 1");
$total_commissions_stmt->execute();
$total_commissions = $total_commissions_stmt->fetchColumn();

$total_pages = ceil($total_commissions / $per_page);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IB User Commission List</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex flex-col md:flex-row h-screen">
    <?php include "side_bar.php"; ?>

    <main class="flex-1 p-4 md:p-6 md:ml-64">
        <div class="container mx-auto">
            <h1 class="text-3xl sm:text-4xl font-bold text-center mb-6 text-[#CD7F32]">IB User Commission List</h1>
            
            <!-- Filter & Search Form -->
            <div class="mb-6 flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
                <form class="flex flex-col sm:flex-row items-center gap-4">
                    <label class="text-[#CD7F32] font-semibold">Date:</label>
                    <input type="date" name="date_filter" class="px-4 py-2 border border-gray-300 rounded-lg w-full sm:w-auto">
                    <button type="submit" class="px-4 py-2 bg-[#CD7F32] text-white rounded-lg w-full sm:w-auto">Filter</button>
                </form>
                <form class="flex flex-col sm:flex-row items-center gap-4">
                    <input type="text" name="search" placeholder="Search by Order ID or Symbol" class="px-4 py-2 border border-gray-300 rounded-lg w-full sm:w-auto">
                    <button type="submit" class="px-4 py-2 bg-[#CD7F32] text-white rounded-lg w-full sm:w-auto">Search</button>
                </form>
            </div>

            <!-- Table -->
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white border border-gray-200 rounded-lg shadow-md text-sm sm:text-base">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="px-4 py-3 border-b text-left text-[#CD7F32]">ID</th>
                            <th class="px-4 py-3 border-b text-left text-[#CD7F32]">MT5 ID</th>
                            <th class="px-4 py-3 border-b text-left text-[#CD7F32]">Date</th>
                            <th class="px-4 py-3 border-b text-left text-[#CD7F32]">Order ID</th>
                            <th class="px-4 py-3 border-b text-left text-[#CD7F32]">Symbol</th>
                            <th class="px-4 py-3 border-b text-left text-[#CD7F32]">Price</th>
                            <th class="px-4 py-3 border-b text-left text-[#CD7F32]">Profit</th>
                            <th class="px-4 py-3 border-b text-left text-[#CD7F32]">Volume</th>
                            <th class="px-4 py-3 border-b text-left text-[#CD7F32]">My Commission</th>
                            <th class="px-4 py-3 border-b text-left text-[#CD7F32]">Type</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($commissions as $commission): ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-4 border-b"><?= $commission['id'] ?></td>
                            <td class="px-4 py-4 border-b"><?= $commission['mt5_id'] ?></td>
                            <td class="px-4 py-4 border-b"><?= $commission['date'] ?></td>
                            <td class="px-4 py-4 border-b"><?= $commission['order_id'] ?></td>
                            <td class="px-4 py-4 border-b"><?= $commission['symbol'] ?></td>
                            <td class="px-4 py-4 border-b"><?= $commission['price'] ?></td>
                            <td class="px-4 py-4 border-b"><?= $commission['profit'] ?></td>
                            <td class="px-4 py-4 border-b"><?= $commission['volume'] ?></td>
                            <td class="px-4 py-4 border-b"><?= $commission['my_commission'] ?></td>
                            <td class="px-4 py-4 border-b"><?= ucfirst($commission['type']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-6 flex flex-col sm:flex-row justify-between items-center text-center">
                <span class="text-gray-700 mb-2 sm:mb-0">Page <?= $page ?> of <?= $total_pages ?></span>
                <div class="flex space-x-4">
                    <?php if ($page > 1): ?>
                        <a href="?page=<?= $page - 1 ?>" class="px-4 py-2 bg-[#CD7F32] text-white rounded-lg">Previous</a>
                    <?php endif; ?>
                    <?php if ($page < $total_pages): ?>
                        <a href="?page=<?= $page + 1 ?>" class="px-4 py-2 bg-[#CD7F32] text-white rounded-lg">Next</a>
                    <?php endif; ?>
                </div>
            </div><br><br><br>
            <?php include "footer.php"; ?>
        </main>
    </div>
</body>
</html>
