<?php
// Handle form submission to add client to IB
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_id = $_POST['user_id'];
    $ib_id = $_POST['ib_id'];

    // Here you would typically save the user_id and ib_id to the database.
    // Since you requested not to use DB data, we won't perform any database operations here.
    echo "User ID: $user_id, IB Plan ID: $ib_id - Client added to IB successfully!";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Client to IB</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">

    <?php include "header.php"; ?>

    
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

      <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
    <h1 class="text-3xl font-bold text-center mb-6" style="color:#CD7F32;">Move Client to IB</h1>

            <!-- Add Client to IB Form -->
            <form action="add_client_ib.php" method="POST" class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-lg border border-gray-200">

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Select User ID -->
                    <div>
                        <label for="user_id" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">
                            Select User ID:
                        </label>
                        <select id="user_id" name="user_id" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-[#CD7F32]">
                            <option value="1">User 1</option>
                            <option value="2">User 2</option>
                            <option value="3">User 3</option>
                            <option value="4">User 4</option>
                        </select>
                    </div>

                    <!-- Select IB Plan -->
                    <div>
                        <label for="ib_id" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">
                            Select IB Plan:
                        </label>
                        <select id="ib_id" name="ib_id" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-[#CD7F32]">
                            <option value="1">IB Plan A</option>
                            <option value="2">IB Plan B</option>
                            <option value="3">IB Plan C</option>
                            <option value="4">IB Plan D</option>
                        </select>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="mt-6 text-center">
                    <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-md shadow-md hover:bg-green-700 transition duration-300">
                        Add Client to IB
                    </button>
                </div>
            </form>
        </div>

      
    </main>  <?php include "footer.php"; ?>
</div>

</body>
</html>
