<?php
// Sample data (replace with database queries later for clients and MT5 IDs)
$clients = [
    1 => 'Client 1',
    2 => 'Client 2',
    3 => 'Client 3'
];

$mt5_ids = [
    1 => 'MT5 ID 1',
    2 => 'MT5 ID 2',
    3 => 'MT5 ID 3'
];

// Handle form submission to add deposit
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $client_id = $_POST['client_id'];
    $mt5_id = $_POST['mt5_id'];
    $amount = $_POST['amount'];
    $comment = $_POST['comment'];

    // Insert deposit logic here
    // For demonstration, just show the submitted data
    echo "Client ID: $client_id, MT5 ID: $mt5_id, Amount: $amount, Comment: $comment - Deposit added successfully!";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Client Deposit</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

    <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
    <div class="container mx-auto">
        <h1 class="text-4xl font-bold text-center mb-6 text-[#CD7F32]">Add Client Deposit</h1>

        <!-- Deposit Form -->
        <form action="add_deposit.php" method="POST" class="max-w-3xl mx-auto bg-white p-10 rounded-lg shadow-xl border border-gray-200">
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Select Client -->
                <div>
                    <label for="client_id" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Select Client:</label>
                    <select id="client_id" name="client_id" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required>
                        <option value="">-- Select Client --</option>
                        <?php foreach ($clients as $id => $name): ?>
                            <option value="<?php echo $id; ?>"><?php echo $name; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- Select MT5 ID -->
                <div>
                    <label for="mt5_id" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Select MT5 ID:</label>
                    <select id="mt5_id" name="mt5_id" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required>
                        <option value="">-- Select MT5 ID --</option>
                        <?php foreach ($mt5_ids as $id => $name): ?>
                            <option value="<?php echo $id; ?>"><?php echo $name; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- Amount -->
                <div>
                    <label for="amount" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Deposit Amount:</label>
                    <input type="number" id="amount" name="amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter deposit amount" min="1">
                </div>

                <!-- Comment -->
                <div>
                    <label for="comment" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Comment:</label>
                    <textarea id="comment" name="comment" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" rows="4" placeholder="Optional comment"></textarea>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="mt-8 text-center">
                <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                    Add Deposit
                </button>
            </div>
        </form>
    </div>
</div>
</main><?php include "footer.php";?>
</div>
   
</body>
</html>
