<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Marketing User</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">

<div class="flex min-h-screen bg-gray-100">
    <!-- Sidebar -->
    <?php include "side_bar.php";?>

    <!-- Main Content -->
    <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
           <h1 class="text-4xl font-bold text-center text-[#CD7F32] mb-8">Add Marketing User</h1>

            <!-- Form to Add Marketing User -->
            <form action="#" method="POST" class="max-w-3xl mx-auto bg-white p-10 rounded-2xl shadow-xl border border-gray-200">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Name Input -->
                    <div>
                        <label for="name" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Name:</label>
                        <input type="text" id="name" name="name" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter name">
                    </div>

                    <!-- Email Input -->
                    <div>
                        <label for="email" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Email:</label>
                        <input type="email" id="email" name="email" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter email">
                    </div>

                    <!-- Password Input -->
                    <div>
                        <label for="password" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Password:</label>
                        <input type="password" id="password" name="password" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter password">
                    </div>

                    <!-- Incentive Input -->
                    <div>
                        <label for="incentive" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Incentive (%):</label>
                        <input type="number" id="incentive" name="incentive" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter incentive percentage">
                    </div>

                    <!-- Net Deposit Input -->
                    <div>
                        <label for="net_deposit" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Net Deposit (Monthly):</label>
                        <input type="number" id="net_deposit" name="net_deposit" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter net deposit">
                    </div>

                    <!-- Role Dropdown -->
                    <div>
                        <label for="role" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Select Role:</label>
                        <select id="role" name="role" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]">
                            <option value="admin">Admin</option>
                            <option value="marketing">Marketing</option>
                            <option value="support">Support</option>
                            <option value="user">User</option>
                        </select>
                    </div>

                    <!-- Manager Selection -->
                    <div>
                        <label for="manager" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Select Manager:</label>
                        <select id="manager" name="manager" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]">
                            <option value="">-- Select Manager --</option>
                            <?php foreach ($managers as $id => $name): ?>
                                <option value="<?php echo $id; ?>"><?php echo $name; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="mt-8 text-center">
                    <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-bold rounded-lg shadow-md hover:bg-[#B87333] hover:scale-105 transition duration-300">
                        Add Marketing User
                    </button>
                </div>
            </form>
        </div>
    </main>
</div>

<?php include "footer.php";?>

</body>
</html>
