
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head><style>/* Basic Styles */
body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
    background-color: #f7f7f7;
}

.container {
    padding: 40px;
    max-width: 1200px;
    margin: 0 auto;
    background-color: #fff;
    box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
    border-radius: 8px;
}

h2 {
    font-size: 32px;
    margin-bottom: 20px;
    color:#CD7F32;
    text-align: center;
}

/* Form Styles */
.settings-form {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.section {
    margin-bottom: 30px;
}

h3 {
    font-size: 24px;
    color: #CD7F32;
    margin-bottom: 10px;
    border-bottom: 2px solid #e0e0e0;
    padding-bottom: 10px;
}

/* Input Styles */
input, select {
    width: 100%;
    padding: 12px;
    margin-bottom: 15px;
    border: 1px solid #ddd;
    border-radius: 5px;
    font-size: 16px;
    color:#CD7F32;
}

input[type="number"] {
    -moz-appearance: textfield;
}

input:focus, select:focus {
    outline: none;
    border-color: #007bff;
}

/* Submit Button Styles */
.submit-btn {
    background-color: #007bff;
    color: white;
    padding: 15px 30px;
    border: none;
    border-radius: 5px;
    font-size: 18px;
    cursor: pointer;
    transition: background-color 0.3s;
    margin-top: 20px;
}

.submit-btn:hover {
    background-color: #0056b3;
}

/* Responsive Design */
@media (max-width: 768px) {
    .container {
        padding: 20px;
    }

    .settings-form {
        gap: 15px;
    }
}
</style>
<body class="bg-gray-100 text-[#CD7F32]">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen text-[#CD7F32]">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
     <div class="container ">
        <h2>Admin Trading Settings</h2>
        <form class="settings-form">
            <!-- Trading Parameters Section -->
            <div class="section">
                <h3>Trading Parameters</h3>
                <label for="trading-hours">Trading Hours:</label>
                <input type="text" id="trading-hours" placeholder="Enter Trading Hours (e.g. 9:00 AM - 5:00 PM)">
                
                <label for="lot-size">Lot Size:</label>
                <input type="number" id="lot-size" placeholder="Enter Lot Size (e.g. 100)">
                
                <label for="max-leverage">Max Leverage:</label>
                <input type="number" id="max-leverage" placeholder="Enter Max Leverage (e.g. 50)">
            </div>

            <!-- Payment Gateway Section -->
            <div class="section">
                <h3>Payment Gateway</h3>
                <label for="payment-gateway">Select Payment Gateway:</label>
                <select id="payment-gateway">
                    <option value="paypal">PayPal</option>
                    <option value="stripe">Stripe</option>
                    <option value="bank-transfer">Bank Transfer</option>
                </select>

                <label for="currency">Currency:</label>
                <select id="currency">
                    <option value="usd">USD</option>
                    <option value="eur">EUR</option>
                    <option value="gbp">GBP</option>
                </select>
            </div>

            <!-- User Roles Section -->
            <div class="section">
                <h3>User Roles</h3>
                <label for="admin-role">Admin Role:</label>
                <input type="text" id="admin-role" placeholder="Enter Admin Role">

                <label for="trader-role">Trader Role:</label>
                <input type="text" id="trader-role" placeholder="Enter Trader Role">
            </div>

            <!-- Notification Settings Section -->
            <div class="section">
                <h3>Notification Settings</h3>
                <label for="trade-notifications">Enable Trade Notifications:</label>
                <select id="trade-notifications">
                    <option value="enabled">Enabled</option>
                    <option value="disabled">Disabled</option>
                </select>

                <label for="email-notifications">Enable Email Notifications:</label>
                <select id="email-notifications">
                    <option value="enabled">Enabled</option>
                    <option value="disabled">Disabled</option>
                </select>
            </div>

            <!-- Company Information Section -->
            <div class="section">
                <h3>Company Information</h3>
                <label for="company-name">Company Name:</label>
                <input type="text" id="company-name" placeholder="Enter Company Name">

                <label for="company-address">Company Address:</label>
                <input type="text" id="company-address" placeholder="Enter Company Address">

                <label for="company-contact">Company Contact:</label>
                <input type="text" id="company-contact" placeholder="Enter Company Contact Number">
            </div>

            <!-- Submit Button -->
            <button type="submit" class="submit-btn bg-[#CD7F32]">Save Settings</button>
        </form>
    </div><br><br><br>
</main>

<?php
// Include the footer
include "footer.php";
?>
</div>