<?php
// Database connection (replace with your own details)
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "your_database";

$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if an ID is provided in the URL
if (isset($_GET['id'])) {
    $marketing_id = $_GET['id'];
    
    // Fetch marketing user details from the database
    $sql = "SELECT * FROM marketing_users WHERE id = $marketing_id";
    $result = $conn->query($sql);
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $name = $row['name'];
        $email = $row['email'];
        $wallet_balance = $row['wallet_balance'];
        $incentive = $row['incentive'];
        $net_deposit = $row['net_deposit'];
        $total_clients = $row['total_clients'];
        $total_deposits = $row['total_deposits'];
        $total_withdrawal = $row['total_withdrawal'];
        $password = $row['password'];
        $role = $row['role'];
        $manager_name = $row['manager_name'];
    } else {
        echo "Marketing user not found!";
        exit;
    }
}

// Handle form submission to update the marketing user
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $new_name = mysqli_real_escape_string($conn, $_POST['name']);
    $new_email = mysqli_real_escape_string($conn, $_POST['email']);
    $new_wallet_balance = mysqli_real_escape_string($conn, $_POST['wallet_balance']);
    $new_incentive = mysqli_real_escape_string($conn, $_POST['incentive']);
    $new_net_deposit = mysqli_real_escape_string($conn, $_POST['net_deposit']);
    $new_total_clients = mysqli_real_escape_string($conn, $_POST['total_clients']);
    $new_total_deposits = mysqli_real_escape_string($conn, $_POST['total_deposits']);
    $new_total_withdrawal = mysqli_real_escape_string($conn, $_POST['total_withdrawal']);
    $new_password = mysqli_real_escape_string($conn, $_POST['password']);
    $new_role = mysqli_real_escape_string($conn, $_POST['role']);
    $new_manager_name = mysqli_real_escape_string($conn, $_POST['manager_name']);
    
    // Update marketing user details in the database
    $update_sql = "UPDATE marketing_users SET name = '$new_name', email = '$new_email', 
                   wallet_balance = '$new_wallet_balance', incentive = '$new_incentive',
                   net_deposit = '$new_net_deposit', total_clients = '$new_total_clients',
                   total_deposits = '$new_total_deposits', total_withdrawal = '$new_total_withdrawal',
                   password = '$new_password', role = '$new_role', manager_name = '$new_manager_name'
                   WHERE id = $marketing_id";
    
    if ($conn->query($update_sql) === TRUE) {
        echo "Marketing user updated successfully!";
        header("Location: marketing_list.php"); // Redirect back to the marketing list
    } else {
        echo "Error updating marketing user: " . $conn->error;
    }
}

// Close the connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Marketing User</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

   <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container"> 
     <h1 class="text-3xl font-bold text-center mb-6">Edit Marketing User</h1>

        <form action="edit_marketing.php?id=<?php echo $marketing_id; ?>" method="POST" class="max-w-lg mx-auto bg-white p-6 rounded-lg shadow-md">
            <!-- Marketing user form fields -->
            <div class="mb-4">
                <label for="name" class="block text-gray-600 text-lg font-medium mb-2">Name:</label>
                <input type="text" id="name" name="name" value="<?php echo $name; ?>" class="w-full px-4 py-2 border border-gray-300 rounded-md" required>
            </div>
            <div class="mb-4">
                <label for="email" class="block text-gray-600 text-lg font-medium mb-2">Email:</label>
                <input type="email" id="email" name="email" value="<?php echo $email; ?>" class="w-full px-4 py-2 border border-gray-300 rounded-md" required>
            </div>
            <div class="mb-4">
                <label for="wallet_balance" class="block text-gray-600 text-lg font-medium mb-2">Wallet Balance:</label>
                <input type="number" id="wallet_balance" name="wallet_balance" value="<?php echo $wallet_balance; ?>" class="w-full px-4 py-2 border border-gray-300 rounded-md" required>
            </div>
            <div class="mb-4">
                <label for="incentive" class="block text-gray-600 text-lg font-medium mb-2">Incentive (%) :</label>
                <input type="number" id="incentive" name="incentive" value="<?php echo $incentive; ?>" class="w-full px-4 py-2 border border-gray-300 rounded-md" required>
            </div>
            <!-- Add similar fields for other attributes like net_deposit, total_clients, etc. -->

            <button type="submit" class="w-full py-3 bg-blue-600 text-white font-semibold rounded-md shadow-md hover:bg-blue-700">Update Marketing User</button>
        </form>
    </div>

</body>
</html>
