<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Follow Up List</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>
        
        <!-- Main Content -->
          <!-- Main Content -->
        <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
     <div class="container mx-auto p-2">
    <input type="text" id="search" placeholder="Search..." class="p-2 border border-gray-300 rounded-lg w-full sm:w-1/2 md:w-1/3 mb-4" oninput="filterTable()">

    <h2 class="text-l sm:text-xl font-bold text-gray-700 mb-4">Follow Up List</h2>

    <div class="overflow-x-auto">
        <table class="min-w-full bg-white border border-gray-300 rounded-md">
            <thead class="bg-gray-200">
                <tr class="text-xs sm:text-sm md:text-base">
                    <th class="p-2 sm:p-2 border-b">ID</th>
                    <th class="p-2 sm:p-2 border-b">Name</th>
                    <th class="p-2 sm:p-2 border-b">Email</th>
                    <th class="p-2 sm:p-2 border-b">Country</th>
                    <th class="p-2 sm:p-2 border-b">Date</th>
                    <th class="p-2 sm:p-2 border-b">Marketing Name</th>
                    <th class="p-2 sm:p-2 border-b">Actions</th>
                </tr>
            </thead>
            <tbody id="table-body" class="text-xs sm:text-sm md:text-base">
                <?php
                $query = "SELECT id, name, email, country, follow_up_date, marketing_name FROM follow_ups";
                $result = $conn->query($query);

                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr class='border-t'>";
                        echo "<td class='p-2 sm:p-2'>" . $row['id'] . "</td>";
                        echo "<td class='p-2 sm:p-2'>" . $row['name'] . "</td>";
                        echo "<td class='p-2 sm:p-2'>" . $row['email'] . "</td>";
                        echo "<td class='p-2 sm:p-2'>" . $row['country'] . "</td>";
                        echo "<td class='p-2 sm:p-2'>" . $row['follow_up_date'] . "</td>";
                        echo "<td class='p-2 sm:p-2'>" . $row['marketing_name'] . "</td>";
                        echo "<td class='p-2 sm:p-2'><a href='update_follow_up.php?id=" . $row['id'] . "' class='text-blue-600'>Update</a></td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='7' class='p-2 text-center'>No records found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>
<br><br><br>
    <!-- Footer -->
    <?php include "footer.php";?>
        </main>
    </div>


    <script>
        // Function to filter the table based on the search input
        function filterTable() {
            const searchInput = document.getElementById("search").value.toLowerCase();
            const tableRows = document.querySelectorAll("#table-body tr");

            tableRows.forEach(row => {
                const cells = row.querySelectorAll("td");
                let match = false;

                // Loop through each cell in the row and check if it contains the search input
                cells.forEach(cell => {
                    if (cell.textContent.toLowerCase().includes(searchInput)) {
                        match = true;
                    }
                });

                // Show or hide the row based on whether it matches the search input
                row.style.display = match ? "" : "none";
            });
        }
    </script>
</body>
</html>

</html>
