<?php
session_start();
error_reporting(0);
include('config.php');
require_once('auth_guard.php');
if (empty($_SESSION['csrf'])) { $_SESSION['csrf'] = bin2hex(random_bytes(16)); }
$CSRF = $_SESSION['csrf'];

function bad($msg, $code = 400) { http_response_code($code); echo $msg; exit; }

/* ===========================
   CREATE
=========================== */
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>IB Users</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<style>
/* ---- Page polish ---- */
body { background: #f7f8fb; }
.table-wrap{overflow:auto}
.card { border: 1px solid #e9edf3; }
.table thead th { font-weight: 600; letter-spacing: .2px; }
.badge-status{font-size:.75rem}

/* ---- Premium Modals ---- */
.modal-dialog { max-width: 920px; }
.modal-dialog-centered { display: flex; align-items: center; min-height: calc(100% - 1rem); }
.modal-content {
  border: 1px solid #e9edf3;
  border-radius: 16px;
  box-shadow: 0 14px 40px rgba(16,24,40,.18);
  overflow: hidden;
}
.modal-header {
  padding: 16px 20px;
  border-bottom: 1px solid #eef2f6;
  background: linear-gradient(135deg, #f8fafc 0%, #eef5ff 100%);
}
.modal-title { font-size: 1.1rem; font-weight: 700; color:#0f172a; display:flex; align-items:center; gap:.5rem; }
.modal-body { padding: 18px 20px; }
.modal-footer { padding: 12px 20px; border-top: 1px solid #eef2f6; }

/* Section headers inside modals */
.section-title {
  font-size: .9rem; font-weight: 700; color:#334155; letter-spacing:.2px;
  margin: 2px 0 10px; display:flex; align-items:center; gap:.5rem;
}
.section-title i { color:#2563eb; }

/* View modal table */
#viewGrid {
  display:grid; grid-template-columns: 1fr 1fr; gap:10px 18px;
}
.kv { display:flex; gap:10px; }
.kv .k { min-width:160px; font-weight:600; color:#475467; background:#f9fafb; border:1px solid #eef2f6; border-radius:10px; padding:10px 12px; }
.kv .v { flex:1; color:#101828; background:white; border:1px solid #eef2f6; border-radius:10px; padding:10px 12px; position:relative; }

/* Pills & chips */
.pill {
  display:inline-flex; align-items:center; gap:.35rem;
  padding:.25rem .55rem; border-radius:999px; font-size:.78rem;
  border:1px solid #e5e7eb; background:#f9fafb; color:#334155;
}
.pill i { font-size:.9rem; }

/* Icon buttons inside value cells */
.v .btn-copy {
  position:absolute; right:8px; top:8px; border:none;
  background:#eef2f6; color:#334155; border-radius:8px; padding:4px 7px; font-size:.8rem;
}
.v .btn-copy:hover { background:#e2e8f0; }

/* Edit modal forms */
.divider { height:1px; background:#eef2f6; margin:10px 0 14px; }
.form-floating>.form-control, .form-floating>.form-select { border-radius:10px; }
.input-group-text { background:#f8fafc; border-radius:10px 0 0 10px; }

/* Buttons */
.btn-icon { display:inline-flex; align-items:center; gap:.45rem; }
</style>
</head>
<body class="bg-gray-100">
<?php include "header.php"; ?>

<!-- Page shell leaves space for fixed sidebar on md+ -->
<div class="min-h-screen md:pl-64">
  <?php include "side_bar.php"; ?>
   <main class="px-4 sm:px-6 py-6">
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0">IB Clients</h1>
    <!--<button class="btn btn-primary btn-icon" data-bs-toggle="modal" data-bs-target="#modalAdd">-->
    <!--  <i class="bi bi-plus-lg"></i> Add New-->
    <!--</button>-->
  </div>

  <div class="table-wrap card shadow-sm">
    <div class="card-body p-0">
              <table id="example" class="table table-striped mb-0">
                <thead>
                  <tr>
                    <th>Client Email</th>
                    <th>Name</th>
                    <th>Country</th>
                    <th>Number</th>
                    <th>Reg Date</th>
                    <th>Status</th>
                    <th>IB Email</th>
                  </tr>
                </thead>
                <tbody>
<?php
  $ibEmail = $_SESSION['clogin'];

  // Show direct level-1 clients of this IB
  $sql = "
    SELECT u.email,
           u.fullname,
           u.country,
           u.`number`      AS mobile_number,
           u.status,
           u.reg_date,
           :ibEmail        AS ib_email
    FROM liveaccount la
    JOIN aspnetusers u ON u.email = la.email
      WHERE la.ib1=:ibEmail OR la.ib2=:ibEmail OR la.ib3=:ibEmail OR la.ib4=:ibEmail
     OR la.ib5=:ibEmail OR la.ib6=:ibEmail OR la.ib7=:ibEmail OR la.ib8=:ibEmail
     OR la.ib9=:ibEmail OR la.ib10=:ibEmail
    ORDER BY u.reg_date DESC
  ";

  // If you want ALL levels (1–10), use this WHERE instead:
  // WHERE la.ib1=:ibEmail OR la.ib2=:ibEmail OR la.ib3=:ibEmail OR la.ib4=:ibEmail
  //    OR la.ib5=:ibEmail OR la.ib6=:ibEmail OR la.ib7=:ibEmail OR la.ib8=:ibEmail
  //    OR la.ib9=:ibEmail OR la.ib10=:ibEmail

  $query = $conn->prepare($sql);
  $query->bindParam(':ibEmail', $ibEmail, PDO::PARAM_STR);
  $query->execute();
  $results = $query->fetchAll(PDO::FETCH_OBJ);

  if ($results) {
    foreach ($results as $r) {
      $isActive = (string)$r->status === '1';
?>
      <tr>
        <td><div><?= htmlspecialchars($r->email) ?></div></td>
        <td><div><?= htmlspecialchars($r->fullname) ?></div></td>
        <td><div><?= htmlspecialchars($r->country) ?></div></td>
        <td><div><?= htmlspecialchars($r->mobile_number) ?></div></td>
        <td><div><?= htmlspecialchars($r->reg_date) ?></div></td>
        <td>
          <!-- BS5 badges -->
          <span class="badge <?= $isActive ? 'bg-success' : 'bg-danger' ?>">
            <?= $isActive ? 'Active' : 'Inactive' ?>
          </span>
        </td>
        <td><div><?= htmlspecialchars($ibEmail) ?></div></td>
      </tr>
<?php
    }
  } else {
?>
    <tr><td colspan="7" class="text-center text-muted">No users found for your IB.</td></tr>
<?php } ?>
</tbody>

                  </table>
    </div>
  </div>
</div></main>

</body>
</html>
