<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Incentive Report</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <?php include "header.php";?>

    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-4 md:p-6 md:ml-64">
            <div class="container mx-auto">
                <h1 class="text-xl sm:text-2xl md:text-3xl font-bold text-center mb-4 md:mb-6">Incentive Report</h1>

                <!-- Incentive Report Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white border border-gray-300 rounded-lg shadow-md">
                        <thead>
                            <tr class="bg-gray-200 text-gray-700 text-xs sm:text-sm md:text-base">
                                <th class="px-3 sm:px-6 py-2 sm:py-3 text-left">Serial No.</th>
                                <th class="px-3 sm:px-6 py-2 sm:py-3 text-left">Name/Email</th>
                                <th class="px-3 sm:px-6 py-2 sm:py-3 text-left">Amount</th>
                                <th class="px-3 sm:px-6 py-2 sm:py-3 text-left">Incentive (%)</th>
                                <th class="px-3 sm:px-6 py-2 sm:py-3 text-left">Net Deposit</th>
                                <th class="px-3 sm:px-6 py-2 sm:py-3 text-left">Total Net Deposit</th>
                                <th class="px-3 sm:px-6 py-2 sm:py-3 text-left">Note</th>
                            </tr>
                        </thead>
                        <tbody class="text-xs sm:text-sm md:text-base">
                            <!-- Sample Data -->
                            <tr class="border-b border-gray-200">
                                <td class="px-3 sm:px-6 py-2 sm:py-3">1</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">John Doe / john@example.com</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">$500</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">10%</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">$5,000</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">$50,000</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">Marketing Incentive for January</td>
                            </tr>
                            <tr class="border-b border-gray-200">
                                <td class="px-3 sm:px-6 py-2 sm:py-3">2</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">Jane Smith / jane@example.com</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">$300</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">8%</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">$3,000</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">$30,000</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">Marketing Incentive for February</td>
                            </tr>
                            <tr class="border-b border-gray-200">
                                <td class="px-3 sm:px-6 py-2 sm:py-3">3</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">David Lee / david@example.com</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">$400</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">12%</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">$4,500</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">$45,000</td>
                                <td class="px-3 sm:px-6 py-2 sm:py-3">Quarterly Incentive Payment</td>
                            </tr>
                            <!-- Add more rows dynamically from PHP -->
                        </tbody>
                    </table>
                </div>
            </div>
            <?php include "footer.php";?>
        </main>
    </div>
</body>
</html>
