<?php
// Handle internal transfer
$clients = [
    1 => 'Client 1',
    2 => 'Client 2',
    3 => 'Client 3'
];

// Handle form submission for internal transfer
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $client_id = $_POST['client_id'];
    $from_mt5_id = $_POST['from_mt5_id'];
    $to_mt5_id = $_POST['to_mt5_id'];
    $amount = $_POST['amount'];
    $comment = $_POST['comment'];

    // Insert internal transfer logic here
    echo "Client ID: $client_id, From MT5 ID: $from_mt5_id, To MT5 ID: $to_mt5_id, Amount: $amount, Comment: $comment - Transfer processed successfully!";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Internal Transfer</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>
        
        <!-- Main Content -->
         <main class="flex-1 p-6 md:ml-64">
            <div class="container">
                <h1 class="text-4xl font-bold text-center mb-6 text-[#CD7F32]">Internal Transfer</h1>

        <!-- Withdrawal Form -->
        <form action="withdrawal.php" method="POST" class="max-w-lg mx-auto bg-white p-8 rounded-lg shadow-lg space-y-6">

            <!-- Select Client -->
            <div>
                <label for="client_id" class="block text-lg font-medium text-gray-700 mb-2">Select Client:</label>
                <select id="client_id" name="client_id" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-[#CD7F32]" required>
                    <option value="">-- Select Client --</option>
                    <?php foreach ($clients as $id => $name): ?>
                        <option value="<?php echo $id; ?>"><?php echo $name; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- Select MT5 ID -->
            <div>
                <label for="mt5_id" class="block text-lg font-medium text-gray-700 mb-2">Select MT5 ID:</label>
                <select id="mt5_id" name="mt5_id" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-[#CD7F32]" required>
                    <option value="">-- Select MT5 ID --</option>
                    <?php foreach ($mt5_ids as $id => $name): ?>
                        <option value="<?php echo $id; ?>"><?php echo $name; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- Amount -->
            <div>
                <label for="amount" class="block text-lg font-medium text-gray-700 mb-2">Withdrawal Amount:</label>
                <input type="number" id="amount" name="amount" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter withdrawal amount" min="1">
            </div>

            <!-- Comment -->
            <div>
                <label for="comment" class="block text-lg font-medium text-gray-700 mb-2">Comment:</label>
                <textarea id="comment" name="comment" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-[#CD7F32]" rows="4" placeholder="Optional comment"></textarea>
            </div>

            <!-- Submit Button -->
            <div>
                <button type="submit" class="w-full py-3 bg-[#CD7F32] text-white font-semibold rounded-md shadow-md hover:bg-blue-700 transition duration-300">Process Withdrawal</button>
            </div>
        </form><br><br><br>
    </div>
<?php include "footer.php";?></main></div>

</body>
</html>
