<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Single Lead</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <script>
        function showTab(tabId) {
            // Hide all sections
            document.getElementById('lead-details').classList.add('hidden');
            document.getElementById('notes').classList.add('hidden');
            document.getElementById('reminders').classList.add('hidden');

            // Show the clicked tab's content
            document.getElementById(tabId).classList.remove('hidden');

            // Remove active class from all tabs
            document.getElementById('tab-lead-details').classList.remove('bg-[#CD7F32]', 'text-white');
            document.getElementById('tab-notes').classList.remove('bg-[#CD7F32]', 'text-white');
            document.getElementById('tab-reminders').classList.remove('bg-[#CD7F32]', 'text-white');

            // Add active class to the clicked tab
            document.getElementById('tab-' + tabId).classList.add('bg-[#CD7F32]', 'text-white');
        }

        function openReminderPopup() {
            document.getElementById('reminder-popup').classList.remove('hidden');
        }

        function closeReminderPopup() {
            document.getElementById('reminder-popup').classList.add('hidden');
        }

        window.onload = function() {
            showTab('lead-details');
        }
    </script>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
<div class="flex flex-col md:flex-row h-screen">
    <!-- Sidebar -->
    <?php include "side_bar.php";?>

    <!-- Main Content -->
    <main class="flex-1 p-6 md:ml-64">
        <div class="container mx-auto">
            <h1 class="text-3xl font-bold mb-6 text-[#CD7F32]">Single Lead</h1>

            <!-- Tab Navigation -->
            <div class="flex flex-wrap border-b">
                <button id="tab-lead-details" class="px-4 py-2 bg-[#CD7F32] text-white font-semibold flex-1 sm:flex-none" onclick="showTab('lead-details')">Lead Details</button>
                <button id="tab-notes" class="px-4 py-2 text-gray-700 hover:bg-gray-200 font-semibold flex-1 sm:flex-none" onclick="showTab('notes')">Notes</button>
                <button id="tab-reminders" class="px-4 py-2 text-gray-700 hover:bg-gray-200 font-semibold flex-1 sm:flex-none" onclick="showTab('reminders')">Reminders</button>
            </div>

            <!-- Lead List Table -->
            <div id="lead-details" class="p-6">
                <h2 class="text-xl font-semibold mb-4">Lead List</h2>
                <div class="overflow-x-auto">
                    <table class="w-full table-auto border-collapse border border-gray-300">
                        <thead>
                            <tr class="bg-[#CD7F32] text-white">
                                <th class="px-4 py-2 border">Sales Name</th>
                                <th class="px-4 py-2 border">Client Name</th>
                                <th class="px-4 py-2 border">Phone</th>
                                <th class="px-4 py-2 border">Email</th>
                                <th class="px-4 py-2 border">Status</th>
                                <th class="px-4 py-2 border">Country</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="text-sm">
                                <td class="px-4 py-2 border">John Smith</td>
                                <td class="px-4 py-2 border">Client Name 1</td>
                                <td class="px-4 py-2 border">9876543210</td>
                                <td class="px-4 py-2 border">client1@example.com</td>
                                <td class="px-4 py-2 border">Active</td>
                                <td class="px-4 py-2 border">India</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Notes Section -->
            <div id="notes" class="p-6 hidden">
                <h2 class="text-xl font-semibold mb-4 text-[#CD7F32]">Notes</h2>
                <textarea class="w-full p-3 border border-gray-300 rounded-md mb-4" placeholder="Add a note..."></textarea>
                <button class="py-2 px-6 bg-[#CD7F32] text-white rounded-md">Save Note</button>
            </div>

            <!-- Reminders Section -->
            <div id="reminders" class="p-6 hidden">
                <h2 class="text-xl font-semibold mb-4 text-[#CD7F32]">Reminders</h2>
                
                <!-- Add Reminder Button -->
                <button onclick="openReminderPopup()" class="mb-4 py-2 px-6 bg-[#CD7F32] text-white rounded-md">Add Reminder</button>
                
                <!-- Reminder Table -->
                <div class="overflow-x-auto">
                    <table class="w-full table-auto border-collapse border border-gray-300">
                        <thead>
                            <tr class="bg-[#CD7F32] text-white">
                                <th class="px-4 py-2 border">Reminder</th>
                                <th class="px-4 py-2 border">Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="px-4 py-2 border">Meeting with client at 10 AM</td>
                                <td class="px-4 py-2 border">2025-02-05</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Reminder Pop-up (hidden by default) -->
        <div id="reminder-popup" class="fixed inset-0 bg-gray-900 bg-opacity-50 flex items-center justify-center hidden">
            <div class="bg-white p-6 rounded-lg shadow-lg max-w-lg w-full mx-4 sm:mx-auto">
                <h2 class="text-xl font-semibold mb-4 text-[#CD7F32]">Add Reminder</h2>
                <input type="date" class="w-full p-3 border border-gray-300 rounded-md mb-4">
                <textarea class="w-full p-3 border border-gray-300 rounded-md mb-4" placeholder="Reminder details..."></textarea>
                <div class="flex justify-end mt-4">
                    <button onclick="closeReminderPopup()" class="mr-2 px-4 py-2 bg-gray-400 text-white rounded-md">Cancel</button>
                    <button class="px-4 py-2 bg-[#CD7F32] text-white rounded-md">Save</button>
                </div>
            </div>
        </div>
    </main>
</div>
</body>
</html>
