<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lot Report</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-gray-100">
    <?php include "header.php"; ?>

    <div class="flex flex-col md:flex-row h-screen">
        <?php include "side_bar.php"; ?>

        <main class="flex-1 p-6 md:ml-64">
            <div class="container mx-auto bg-white p-6 rounded-lg shadow-lg">
                <h2 class="text-3xl font-semibold text-center text-gray-700 mb-6">Lot Report</h2>

                <div class="flex flex-col md:flex-row md:items-center md:justify-center gap-4 mb-6">
                    <div class="flex flex-col">
                        <label for="from" class="text-gray-600">From:</label>
                        <input type="date" id="from" class="border rounded p-2">
                    </div>
                    <div class="flex flex-col">
                        <label for="to" class="text-gray-600">To:</label>
                        <input type="date" id="to" class="border rounded p-2">
                    </div>
                    <button id="submit-btn" class="bg-orange-500 text-white font-bold py-2 px-4 rounded hover:bg-orange-600">Submit</button>
                </div>

                <div class="flex flex-col md:flex-row md:justify-between items-center gap-4 mb-6">
                    <label for="recordsPerPage" class="text-gray-600">Records per page:</label>
                    <select id="recordsPerPage" class="border rounded p-2">
                        <option value="5">5</option>
                        <option value="10" selected>10</option>
                        <option value="15">15</option>
                    </select>
                </div>

                <div class="w-full overflow-x-auto">
                    <canvas id="lotChart" class="w-full max-w-md mx-auto"></canvas>
                </div>

                <div id="lot-data" class="text-center text-gray-600 mt-6">
                    <p>Select a date range and click submit to view data.</p>
                </div>

                <div class="flex justify-center items-center gap-4 mt-6">
                    <button id="prev-page" class="bg-blue-500 text-white py-2 px-4 rounded hover:bg-blue-600">Previous</button>
                    <span id="page-number" class="text-gray-700 font-semibold">Page 1</span>
                    <button id="next-page" class="bg-blue-500 text-white py-2 px-4 rounded hover:bg-blue-600">Next</button>
                </div>
            </div>
        </main>
    </div>

    <?php include "footer.php"; ?>

    <script>
        $(document).ready(function() {
            let currentPage = 1;

            function fetchData() {
                var fromDate = $("#from").val();
                var toDate = $("#to").val();
                var recordsPerPage = $("#recordsPerPage").val();

                if (fromDate && toDate) {
                    $.ajax({
                        url: "fetch_data.php",
                        type: "GET",
                        data: { from: fromDate, to: toDate, page: currentPage, recordsPerPage: recordsPerPage },
                        dataType: "json",
                        success: function(response) {
                            $("#lot-data").html(response.tableData);
                            updateChart(response.chartData);
                            $("#page-number").text("Page " + currentPage);
                            $("#prev-page").prop("disabled", currentPage === 1);
                            $("#next-page").prop("disabled", response.totalPages <= currentPage);
                        },
                        error: function() {
                            alert("Error fetching data.");
                        }
                    });
                } else {
                    alert("Please select both dates!");
                }
            }

            $("#submit-btn").click(function() {
                currentPage = 1;
                fetchData();
            });

            $("#recordsPerPage").change(function() {
                currentPage = 1;
                fetchData();
            });

            $("#prev-page").click(function() {
                if (currentPage > 1) {
                    currentPage--;
                    fetchData();
                }
            });

            $("#next-page").click(function() {
                currentPage++;
                fetchData();
            });
        });

        let lotChart;

        function updateChart(chartData) {
            if (lotChart) {
                lotChart.destroy();
            }

            let ctx = document.getElementById('lotChart').getContext('2d');
            lotChart = new Chart(ctx, {
                type: 'pie',
                data: {
                    labels: chartData.labels,
                    datasets: [{
                        label: 'Lots per Symbol',
                        data: chartData.data,
                        backgroundColor: ['#ff6384', '#36a2eb', '#ffce56', '#4bc0c0', '#9966ff']
                    }]
                }
            });
        }
    </script>
</body>
</html>
