<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Money Manager PAMM Request List</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <?php include "header.php"; ?>

    <div class="flex flex-col md:flex-row h-screen">
        <?php include "side_bar.php"; ?>

        <main class="flex-1 p-4 md:p-6 md:ml-64">
            <div class="container mx-auto">
                <h1 class="text-2xl md:text-3xl font-semibold text-center text-[#CD7F32] mb-6">Money Manager PAMM Request List</h1>

                <!-- Download Buttons -->
                <div class="flex flex-wrap justify-center gap-3 mb-6">
                    <a href="download_excel_mm.php" class="bg-green-600 text-white px-4 py-2 rounded-md shadow-md hover:bg-green-700 transition duration-300 text-sm md:text-base">
                        Download Excel
                    </a>
                    <a href="download_pdf_mm.php" class="bg-red-600 text-white px-4 py-2 rounded-md shadow-md hover:bg-red-700 transition duration-300 text-sm md:text-base">
                        Download PDF
                    </a>
                </div>

                <!-- Responsive Table -->
                <div class="overflow-x-auto">
                    <table class="w-full bg-white border border-gray-300 rounded-lg shadow-md text-xs md:text-sm">
                        <thead class="bg-[#CD7F32] text-white">
                            <tr>
                                <th class="py-2 px-2 text-left">Request ID</th>
                                <th class="py-2 px-2 text-left">Name</th>
                                <th class="py-2 px-2 text-left">Email</th>
                                <th class="py-2 px-2 text-left">Min. Investment</th>
                                <th class="py-2 px-2 text-left">Performance Fee</th>
                                <th class="py-2 px-2 text-left">Per Deal/Per Lot</th>
                                <th class="py-2 px-2 text-left">Fees</th>
                                <th class="py-2 px-2 text-left">User Type</th>
                                <th class="py-2 px-2 text-left">Registration Date</th>
                                <th class="py-2 px-2 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Dummy Data Rows -->
                            <tr class="border-b hover:bg-[#F8E6D1] transition">
                                <td class="py-2 px-2">1</td>
                                <td class="py-2 px-2">John Doe</td>
                                <td class="py-2 px-2 truncate max-w-[150px]">johndoe@email.com</td>
                                <td class="py-2 px-2">$5000</td>
                                <td class="py-2 px-2">20%</td>
                                <td class="py-2 px-2">Per Lot</td>
                                <td class="py-2 px-2">5%</td>
                                <td class="py-2 px-2">Manager</td>
                                <td class="py-2 px-2">2025-02-01</td>
                                <td class="py-2 px-2 flex flex-wrap gap-2">
                                    <a href="approve_mm_request.php?id=1" class="text-green-500 hover:underline">Approve</a>
                                    <a href="reject_mm_request.php?id=1" class="text-red-500 hover:underline">Reject</a>
                                </td>
                            </tr>
                            <!-- More rows can be added similarly -->
                        </tbody>
                    </table>
                </div>
            </div>
        </main>

        <?php include "footer.php"; ?>
    </div>
</body>
</html>
