<?php
// Hardcoded user data for example purposes
$users = ["User 1", "User 2", "User 3"];

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_name = $_POST['user_name'];
    $account_id = $_POST['account_id'];
    $request_note = $_POST['request_note'];

    // Database insertion logic goes here (for example, using PDO or MySQLi)
    echo "<p class='text-green-600 font-bold text-center mt-4'>Master Copier Request Submitted Successfully!</p>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Master Copier Request</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

   <main class="flex-1 p-6 md:ml-64">
            <div class="container">
             <h1 class="text-3xl font-bold text-center mb-6" style="color:#CD7F32;">Master Copier Request</h1>

        <!-- Master Copier Request Form -->
        <form action="" method="POST">
            
            <!-- Select User Dropdown -->
            <div class="mb-6">
                <label for="user_name" class="block text-gray-600 text-lg font-medium mb-2">Select User:</label>
                <select id="user_name" name="user_name" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-600" required>
                    <option value="">-- Select User --</option>
                    <?php foreach ($users as $user): ?>
                        <option value="<?= $user ?>"><?= $user ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- Account ID Input -->
            <div class="mb-6">
                <label for="account_id" class="block text-gray-600 text-lg font-medium mb-2">Account ID:</label>
                <input type="text" id="account_id" name="account_id" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-600" required>
            </div>

            <!-- Request Note Input -->
            <div class="mb-6">
                <label for="request_note" class="block text-gray-600 text-lg font-medium mb-2">Request Note:</label>
                <textarea id="request_note" name="request_note" rows="4" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-600" required></textarea>
            </div>

            <!-- Submit Button -->
            <button type="submit" class="w-full py-3 bg-[#CD7F32] text-white font-semibold rounded-md shadow-md hover:bg-blue-700 transition duration-300">Submit Request</button>
        </form>
    </div><br><br><br>
</main><?php include "footer.php";?>
</div>
</body>
</html>
