<?php
// Dummy data for promotions
$promotions = [
    ['id' => 1, 'type' => 'Discount', 'image' => 'promo1.jpg', 'description' => 'Big Sale on Electronics', 'country' => 'USA', 'status' => 'Active', 'date' => '2025-02-01'],
    ['id' => 2, 'type' => 'Flash Sale', 'image' => 'promo2.jpg', 'description' => 'Limited Time Offer on Fashion', 'country' => 'Canada', 'status' => 'Inactive', 'date' => '2025-02-02'],
    ['id' => 3, 'type' => 'Buy 1 Get 1', 'image' => 'promo3.jpg', 'description' => 'Special Offer on Grocery Items', 'country' => 'UK', 'status' => 'Active', 'date' => '2025-02-03'],
    ['id' => 4, 'type' => 'Clearance', 'image' => 'promo4.jpg', 'description' => 'Up to 50% off on Furniture', 'country' => 'Australia', 'status' => 'Inactive', 'date' => '2025-02-04'],
    ['id' => 1, 'type' => 'Discount', 'image' => 'promo1.jpg', 'description' => 'Big Sale on Electronics', 'country' => 'USA', 'status' => 'Active', 'date' => '2025-02-01'],
    ['id' => 2, 'type' => 'Flash Sale', 'image' => 'promo2.jpg', 'description' => 'Limited Time Offer on Fashion', 'country' => 'Canada', 'status' => 'Inactive', 'date' => '2025-02-02'],
    ['id' => 3, 'type' => 'Buy 1 Get 1', 'image' => 'promo3.jpg', 'description' => 'Special Offer on Grocery Items', 'country' => 'UK', 'status' => 'Active', 'date' => '2025-02-03'],
    ['id' => 4, 'type' => 'Clearance', 'image' => 'promo4.jpg', 'description' => 'Up to 50% off on Furniture', 'country' => 'Australia', 'status' => 'Inactive', 'date' => '2025-02-04'],
    ['id' => 1, 'type' => 'Discount', 'image' => 'promo1.jpg', 'description' => 'Big Sale on Electronics', 'country' => 'USA', 'status' => 'Active', 'date' => '2025-02-01'],
    ['id' => 2, 'type' => 'Flash Sale', 'image' => 'promo2.jpg', 'description' => 'Limited Time Offer on Fashion', 'country' => 'Canada', 'status' => 'Inactive', 'date' => '2025-02-02'],
    ['id' => 3, 'type' => 'Buy 1 Get 1', 'image' => 'promo3.jpg', 'description' => 'Special Offer on Grocery Items', 'country' => 'UK', 'status' => 'Active', 'date' => '2025-02-03'],
    ['id' => 4, 'type' => 'Clearance', 'image' => 'promo4.jpg', 'description' => 'Up to 50% off on Furniture', 'country' => 'Australia', 'status' => 'Inactive', 'date' => '2025-02-04'],
    // Add more dummy data as needed
];

// Pagination & Records per page control
$page = isset($_GET['page']) ? $_GET['page'] : 1;
$recordsPerPage = isset($_GET['records_per_page']) ? $_GET['records_per_page'] : 5;
$totalRecords = count($promotions);
$totalPages = ceil($totalRecords / $recordsPerPage);
$startIndex = ($page - 1) * $recordsPerPage;

// Get promotions for the current page
$currentPagePromotions = array_slice($promotions, $startIndex, $recordsPerPage);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Promotion List</title>
    
    <script src="script.js" defer></script>
</head>
<style>/* Basic Styles */
body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
}

.container {
    padding: 20px;
}

/* Button to Create Promotion */
.create-promotion-btn {
    background-color: #4CAF50;
    color: white;
    padding: 10px 20px;
    border: none;
    cursor: pointer;
    margin-bottom: 20px;
}

/* Filters */
.filters {
    margin-bottom: 20px;
    display: flex;
    justify-content: space-between;
}

.filters input, .filters select {
    padding: 10px;
    font-size: 16px;
}

/* Table Styles */
.promotion-table {
    width: 100%;
    border-collapse: collapse;
}

.promotion-table th, .promotion-table td {
    border: 1px solid #ddd;
    padding: 10px;
    text-align: left;
}

.promotion-table th {
    background-color: #f2f2f2;
}

/* Pagination Styles */
.pagination {
    margin-top: 20px;
    text-align: center;
}

.pagination a {
    padding: 10px 15px;
    text-decoration: none;
    color: #007BFF;
    border: 1px solid #ddd;
    margin: 0 5px;
}

.pagination a:hover {
    background-color: #ddd;
}

/* Popup Styles */
/* Popup Background */
.popup {
    display: none; /* Hidden by default */
    position: fixed;
    top: 30px;
    left: 50%;
    transform: translateX(-50%); /* Center horizontally */
    width: 90%; /* Make the width responsive */
    max-width: 600px; /* Optional: maximum width */
    height: auto; /* Height will adjust according to content */
    background-color: rgba(0, 0, 0, 0.5);
    justify-content: center;
    align-items: center;
    z-index: 999;
    padding: 20px; /* Add padding for inner space */
    border-radius: 8px; /* Optional: rounded corners */
}

/* Popup Content */
.popup-content {
    background-color: white;
    padding: 30px;
    border-radius: 8px;
    width: 100%; /* Use 100% width to take full available width */
    height: auto; /* Height will adjust based on content */
    display: flex;
    flex-direction: column;
    gap: 15px;
    box-shadow: none; /* Remove the shadow */
}

/* Popup Heading */
.popup-content h2 {
    margin-bottom: 10px;
    font-size: 20px;
    color: #333;
    text-align: center;
}

/* Form Inputs */
.popup-content label {
    font-size: 12px;
    color: #555;
    margin-bottom: 0px;
}

.popup-content input,
.popup-content select {
    width: 100%;
    padding: 4px;
    margin-bottom: 10px;
    border: 1px solid #ddd;
    border-radius: 5px;
    font-size: 12px;
}

/* Button Styles */
.button {
    background-color: #CD7F32;
    color: white;
    padding: 12px 20px;
    border: none;
    border-radius: 5px;
    font-size: 14px;
    cursor: pointer;
    transition: background-color 0.3s;
}

.button:hover {
    background-color: #b67528;
}

/* Close Button */
.close {
    background-color: #f44336;
}

.close:hover {
    background-color: #d32f2f;
}

/* Popup Button Wrapper */
.popup-buttons {
    display: flex;
    justify-content: space-between;
}


</style><style>@media (max-width: 768px) {
    body {
        font-size: 10px;
    }

    .promotion-table th, .promotion-table td {
        font-size: 10px;
        padding: 5px;
    }

    .popup-content h2 {
        font-size: 16px;
    }

    .popup-content label,
    .popup-content input,
    .popup-content select {
        font-size: 10px;
    }

    .button {
        font-size: 10px;
        padding: 8px 16px;
    }
}
</style>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
     <div class="container">
        <!-- Button to Create Promotion -->
        <button class="create-promotion-btn bg-[#CD7F32]" onclick="openCreatePromotionPopup()">Create Promotion</button>
        
        <!-- Search and Records per Page Control -->
       <div class="filters">
    <input type="text" id="search" placeholder="Search..." oninput="filterPromotions()">
    <select id="records_per_page" onchange="changeRecordsPerPage()">
        <option value="5" <?php echo ($recordsPerPage == 5) ? 'selected' : ''; ?>>5 Records</option>
        <option value="10" <?php echo ($recordsPerPage == 10) ? 'selected' : ''; ?>>10 Records</option>
        <option value="15" <?php echo ($recordsPerPage == 15) ? 'selected' : ''; ?>>15 Records</option>
    </select>
</div>


        <!-- Promotion List Table -->
        <table class="promotion-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Type</th>
                    <th>Image</th>
                    <th>Description</th>
                    <th>Country</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody id="promotion_list">
                <?php foreach ($currentPagePromotions as $promotion): ?>
                    <tr>
                        <td><?php echo $promotion['id']; ?></td>
                        <td><?php echo $promotion['type']; ?></td>
                        <td><img src="<?php echo $promotion['image']; ?>" alt="Promo Image" width="50"></td>
                        <td><?php echo $promotion['description']; ?></td>
                        <td><?php echo $promotion['country']; ?></td>
                        <td><?php echo $promotion['status']; ?></td>
                        <td><?php echo $promotion['date']; ?></td>
                        <td><button>Edit</button> <button>Delete</button></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <!-- Pagination -->
        <div class="pagination">
            <!--<a href="?page=1&records_per_page=<?php echo $recordsPerPage; ?>">&laquo; First</a>-->
            <a href="?page=<?php echo max(1, $page - 1); ?>&records_per_page=<?php echo $recordsPerPage; ?>">Previous</a>
            <span>Page <?php echo $page; ?> of <?php echo $totalPages; ?></span>
            <a href="?page=<?php echo min($totalPages, $page + 1); ?>&records_per_page=<?php echo $recordsPerPage; ?>">Next</a>
          <!--  <a href="?page=<?php echo $totalPages; ?>&records_per_page=<?php echo $recordsPerPage; ?>">Last &raquo;</a>-->
        </div>
    </div>

    <!-- Create Promotion Popup -->
   <div id="createPromotionPopup" class="popup">
    <div class="popup-content">
        <h2>Create Promotion</h2>
        
        <label for="promo_type">Type:</label>
        <input type="text" id="promo_type" placeholder="Enter Promotion Type">

        <label for="promo_image">Image URL:</label>
        <input type="text" id="promo_image" placeholder="Enter Image URL">

        <label for="promo_country">Country:</label>
        <input type="text" id="promo_country" placeholder="Enter Country">

        <label for="promo_status">Status:</label>
        <select id="promo_status">
            <option value="Active">Active</option>
            <option value="Inactive">Inactive</option>
        </select>

        <div class="popup-buttons">
            <button onclick="createPromotion()" class="button">Create</button>
            <button onclick="closeCreatePromotionPopup()" class="button close">Close</button>
        </div>
    </div>
</div>

    </main>
    <?php include "footer.php";?>
    </div>
    <script>
   function openCreatePromotionPopup() {
    document.getElementById('createPromotionPopup').style.display = 'flex';
}

function closeCreatePromotionPopup() {
    document.getElementById('createPromotionPopup').style.display = 'none';
}

function createPromotion() {
    const type = document.getElementById('promo_type').value;
    const image = document.getElementById('promo_image').value;
    const country = document.getElementById('promo_country').value;
    const status = document.getElementById('promo_status').value;

    if (type && image && country && status) {
        alert(`Promotion Created: ${type} - ${status}`);
        closeCreatePromotionPopup();
    } else {
        alert('Please fill all fields');
    }
}

function filterPromotions() {
    const searchQuery = document.getElementById('search').value.toLowerCase();
    const rows = document.querySelectorAll('.promotion-table tbody tr');

    rows.forEach(row => {
        const cells = row.getElementsByTagName('td');
        const description = cells[3].textContent.toLowerCase();
        const country = cells[4].textContent.toLowerCase();
        
        if (description.includes(searchQuery) || country.includes(searchQuery)) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
}

function changeRecordsPerPage() {
    const recordsPerPage = document.getElementById('records_per_page').value;
    const currentPage = getUrlParameter('page') || 1; // Get current page or default to page 1
    window.location.href = `?page=${currentPage}&records_per_page=${recordsPerPage}`;
}

// Helper function to get URL parameter values
function getUrlParameter(name) {
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(name);
}
</script>

</body>
</html>
