<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head><style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f0f4f8;
            color: #333;
            line-height: 1.6;
        }

        .container {
            width: 80%;
            max-width: 900px;
            margin: 50px auto;
            background-color: #fff;
            padding: 40px;
            border-radius: 12px;
        }

        h2 {
            text-align: center;
            font-size: 30px;
            font-weight: 600;
            margin-bottom: 30px;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        label {
            font-size: 14px;
            color: #555;
            margin-bottom: 8px;
        }

        input, select {
            padding: 7px 15px;
            font-size: 12px;
            border: 2px solid #ddd;
            border-radius: 8px;
            background-color: #fafafa;
            width: 100%;
        }

        input:focus, select:focus {
            border-color: #007BFF;
            background-color: #fff;
            outline: none;
        }

        button {
            padding: 10px 20px;
            background-color: #007BFF;
            color: white;
            font-size: 14px;
            font-weight: 500;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.2s ease;
        }

        button:hover {
            background-color: #0056b3;
            transform: translateY(-2px);
        }

        table {
            width: 100%;
            margin-top: 30px;
            border-collapse: collapse;
        }

        table th, table td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ddd;
        }

        table th {
            background-color: #f4f4f4;
        }

        .edit-btn {
            padding: 6px 10px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .edit-btn:hover {
            background-color: #218838;
        }

        /* Popup Modal Styles */
        .modal {
    display: none;
    position: fixed;
    top: 210px;
    left: 0;
    width: 100%;
    height: 30%;
    justify-content: center;
    align-items: center;
}

.modal-content {
    background-color: #fff;
    padding: 30px;
    border-radius: 10px;
    width: 500px;
}

.modal-header {
    font-size: 16px;
    font-weight: bold;
    margin-bottom: 4px;
}

.modal-body {
    display: flex;
    flex-direction: column;
    gap: 6px; /* Reduced gap between inputs */
}

.modal-body label {
    margin-bottom: 2px; /* Decreased space between label and input */
}

.modal-footer {
    text-align: right;
    margin-top: 10px;
}


        .close {
            background-color: #f44336;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .close:hover {
            background-color: #d32f2f;
        }

        @media (max-width: 768px) {
            .container {
                width: 90%;
                padding: 20px;
            }

            h2 {
                font-size: 24px;
            }
        }
    </style>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
      <div class="container">
        <h2>PSP Settings</h2>

        <form method="POST">
            <div>
                <label for="payment_gateway">Payment Gateway</label>
                <select id="payment_gateway" name="payment_gateway" required>
                    <option value="paypal">PayPal</option>
                    <option value="stripe">Stripe</option>
                    <option value="square">Square</option>
                    <option value="razorpay">Razorpay</option>
                </select>
            </div>

            <div>
                <label for="country">Country</label>
                <select id="country" name="country" required>
                    <option value="usa">United States</option>
                    <option value="uk">United Kingdom</option>
                    <option value="canada">Canada</option>
                    <option value="australia">Australia</option>
                </select>
            </div>

            <div>
                <label for="type">Type</label>
                <select id="type" name="type" required>
                    <option value="credit_card">Credit Card</option>
                    <option value="debit_card">Debit Card</option>
                    <option value="net_banking">Net Banking</option>
                    <option value="wallet">Wallet</option>
                </select>
            </div>

            <div>
                <label for="status">Status</label>
                <select id="status" name="status" required>
                    <option value="active">Active</option>
                    <option value="inactive">Inactive</option>
                    <option value="pending">Pending</option>
                </select>
            </div>

            <div>
                <label for="order_no">Order Number</label>
                <input type="number" id="order_no" name="order_no" required>
            </div>

            <div class="button-container">
                <button type="submit">Save Settings</button>
            </div>
        </form>

        <?php
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $payment_gateway = $_POST['payment_gateway'];
            $country = $_POST['country'];
            $type = $_POST['type'];
            $status = $_POST['status'];
            $order_no = $_POST['order_no'];
            $date = date('Y-m-d H:i:s');

            // Data simulation - storing submitted data in an array
            if (!isset($formData)) {
                $formData = [];
            }

            $formData[] = [
                'id' => count($formData) + 1,
                'payment_gateway' => $payment_gateway,
                'country' => $country,
                'status' => $status,
                'type' => $type,
                'order_no' => $order_no,
                'date' => $date
            ];

            // Display the table of submitted data
            echo '<table>';
            echo '<thead>
                    <tr>
                        <th>ID</th>
                        <th>Payment Gateway</th>
                        <th>Country</th>
                        <th>Status</th>
                        <th>Type</th>
                        <th>Order No</th>
                        <th>Date</th>
                        <th>Action</th>
                    </tr>
                </thead><tbody>';

            foreach ($formData as $data) {
                echo '<tr>';
                echo '<td>' . $data['id'] . '</td>';
                echo '<td>' . $data['payment_gateway'] . '</td>';
                echo '<td>' . $data['country'] . '</td>';
                echo '<td>' . $data['status'] . '</td>';
                echo '<td>' . $data['type'] . '</td>';
                echo '<td>' . $data['order_no'] . '</td>';
                echo '<td>' . $data['date'] . '</td>';
                echo '<td><button class="edit-btn" onclick="openEditModal(' . $data['id'] . ', \'' . $data['payment_gateway'] . '\', \'' . $data['country'] . '\', \'' . $data['type'] . '\', \'' . $data['status'] . '\', \'' . $data['order_no'] . '\')">Edit</button></td>';
                echo '</tr>';
            }

            echo '</tbody></table>';
        }
        ?>

        <!-- Modal Popup for Editing -->
        <div id="editModal" class="modal">
            <div class="modal-content">
                <div class="modal-header">Edit Payment Settings</div>
                <div class="modal-body">
                    <form id="editForm">
                        <label for="edit_payment_gateway">Payment Gateway</label>
                        <select id="edit_payment_gateway" name="payment_gateway" required>
                            <option value="paypal">PayPal</option>
                            <option value="stripe">Stripe</option>
                            <option value="square">Square</option>
                            <option value="razorpay">Razorpay</option>
                        </select>

                        <label for="edit_country">Country</label>
                        <select id="edit_country" name="country" required>
                            <option value="usa">United States</option>
                            <option value="uk">United Kingdom</option>
                            <option value="canada">Canada</option>
                            <option value="australia">Australia</option>
                        </select>

                        <label for="edit_type">Type</label>
                        <select id="edit_type" name="type" required>
                            <option value="credit_card">Credit Card</option>
                            <option value="debit_card">Debit Card</option>
                            <option value="net_banking">Net Banking</option>
                            <option value="wallet">Wallet</option>
                        </select>

                        <label for="edit_status">Status</label>
                        <select id="edit_status" name="status" required>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                            <option value="pending">Pending</option>
                        </select>

                        <label for="edit_order_no">Order Number</label>
                        <input type="number" id="edit_order_no" name="order_no" required>
                    </form>
                </div>

                <div class="modal-footer">
                    <button class="close" onclick="closeModal()">Close</button>
                    <button class="close" onclick="saveEdit()">Save Changes</button>
                </div>
            </div>
        </div>
    </div><br><br>
    </main>
    <?php include "footer.php";?>
    </div>

    <script>
        function openEditModal(id, payment_gateway, country, type, status, order_no) {
            document.getElementById('edit_payment_gateway').value = payment_gateway;
            document.getElementById('edit_country').value = country;
            document.getElementById('edit_type').value = type;
            document.getElementById('edit_status').value = status;
            document.getElementById('edit_order_no').value = order_no;
            document.getElementById('editModal').style.display = 'flex';
        }

        function closeModal() {
            document.getElementById('editModal').style.display = 'none';
        }

        function saveEdit() {
            const payment_gateway = document.getElementById('edit_payment_gateway').value;
            const country = document.getElementById('edit_country').value;
            const type = document.getElementById('edit_type').value;
            const status = document.getElementById('edit_status').value;
            const order_no = document.getElementById('edit_order_no').value;

            // Here you would typically update the table with the new values
            // For now, this just closes the modal and simulates saving
            closeModal();
        }
    </script>
</body>
</html>
