<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Remove Bonus</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

    <main class="flex-1 p-8 ml-64">
        <div class="container mx-auto p-6 bg-white rounded-lg shadow-xl w-full max-w-4xl">
            <h2 class="text-3xl font-semibold text-gray-700 mb-6">Remove Bonus</h2>

            <!-- Form -->
            <form action="process_remove_bonus.php" method="POST">
                <!-- Select Bonus Entry -->
                <div class="mb-6">
                    <label for="bonus_id" class="block text-gray-600 text-lg font-medium mb-2">Select Bonus Entry:</label>
                    <select id="bonus_id" name="bonus_id" class="w-full p-3 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-red-400" required>
                        <option value="">Select a Bonus Entry</option>
                        <?php
                            include "db_connection.php";
                            $query = "SELECT id, user_id, amount FROM bonuses ORDER BY created_at DESC";
                            $result = mysqli_query($conn, $query);
                            while ($row = mysqli_fetch_assoc($result)) {
                                echo "<option value='" . $row['id'] . "'>User ID: " . $row['user_id'] . " - Amount: $" . $row['amount'] . "</option>";
                            }
                        ?>
                    </select>
                </div>

                <!-- Submit Button -->
                <button type="submit" class="w-full py-3 bg-red-600 text-white font-semibold rounded-md shadow-md hover:bg-red-700 transition duration-300">
                    Remove Bonus
                </button>
            </form>
        </div>
    </main>
</div>
</body>
</html>
