<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reward List</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Smooth transition for modal */
        #add-reward-modal {
            transition: opacity 0.3s ease;
        }
    </style>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
<div class="flex flex-col md:flex-row h-screen">
    <!-- Sidebar -->
    <?php include "side_bar.php";?>

    <!-- Main Content -->
    <main class="flex-1 p-6 md:ml-64">
        <!-- Top Navigation -->
        <div class="container mx-auto bg-white p-6 shadow-lg rounded-lg">
            <h2 class="text-2xl font-bold mb-3 text-gray-700">Reward List</h2>
            <button onclick="openAddRewardModal()" class="px-4 py-2 bg-blue-500 text-white rounded-md mb-3 hover:bg-blue-600">Add Reward</button>

            <div class="overflow-x-auto">
                <table class="min-w-full border-collapse border border-gray-300" id="reward-table">
                    <thead class="bg-[#CD7F32]">
                        <tr>
                            <th class="p-2 border">ID</th>
                            <th class="p-2 border">Name</th>
                            <th class="p-2 border">Email</th>
                            <th class="p-2 border">Image</th>
                            <th class="p-2 border">Description</th>
                            <th class="p-2 border">Ntc</th>
                            <th class="p-2 border">Min Trade Lot</th>
                            <th class="p-2 border">Min Deposit</th>
                            <th class="p-2 border">Total Deposit</th>
                            <th class="p-2 border">Total Traded Lots</th>
                            <th class="p-2 border">Status</th>
                            <th class="p-2 border">Action</th>
                        </tr>
                    </thead>
                    <tbody id="reward-table-body">
                <!-- Dummy Data for Rewards -->
                <tr>
                    <td class="p-2 border text-center">1</td>
                    <td class="p-2 border">John Doe</td>
                    <td class="p-2 border">john@example.com</td>
                    <td class="p-2 border">
                        <img src="https://via.placeholder.com/50" alt="John's image" class="w-12 h-12 rounded-full">
                    </td>
                    <td class="p-2 border">Lorem ipsum dolor sit amet.</td>
                    <td class="p-2 border">10</td>
                    <td class="p-2 border">1</td>
                    <td class="p-2 border">$500</td>
                    <td class="p-2 border">$10000</td>
                    <td class="p-2 border">500</td>
                    <td class="p-2 border" id="status-1">Active</td>
                    <td class="p-2 border flex space-x-2">
                        <button onclick="viewReward(this)" class="px-4 py-2 text-gray-800 bg-[#E8C9A3] rounded-md hover:bg-[#DFC19A] transition">View</button>
                        <button onclick="editReward(this)" class="px-4 py-2 text-gray-800 bg-[#D6B392] rounded-md hover:bg-[#CBAE88] transition">Edit</button>
                        <button onclick="deleteReward(this)" class="px-4 py-2 text-gray-800 bg-[#E5A07A] rounded-md hover:bg-[#DA9972] transition">Delete</button>
                        <button onclick="toggleStatus(this, 1)" class="px-4 py-2 text-white bg-[#4CAF50] rounded-md hover:bg-[#45a049]">Activate/Deactivate</button>
                    </td>
                </tr>
                <tr>
                    <td class="p-2 border text-center">2</td>
                    <td class="p-2 border">Emma Watson</td>
                    <td class="p-2 border">emma@example.com</td>
                    <td class="p-2 border">
                        <img src="https://via.placeholder.com/50" alt="Emma's image" class="w-12 h-12 rounded-full">
                    </td>
                    <td class="p-2 border">Sed ut perspiciatis unde omnis iste natus.</td>
                    <td class="p-2 border">20</td>
                    <td class="p-2 border">2</td>
                    <td class="p-2 border">$1000</td>
                    <td class="p-2 border">$20000</td>
                    <td class="p-2 border">1000</td>
                    <td class="p-2 border" id="status-2">Inactive</td>
                    <td class="p-2 border flex space-x-2">
                        <button onclick="viewReward(this)" class="px-4 py-2 text-gray-800 bg-[#E8C9A3] rounded-md hover:bg-[#DFC19A] transition">View</button>
                        <button onclick="editReward(this)" class="px-4 py-2 text-gray-800 bg-[#D6B392] rounded-md hover:bg-[#CBAE88] transition">Edit</button>
                        <button onclick="deleteReward(this)" class="px-4 py-2 text-gray-800 bg-[#E5A07A] rounded-md hover:bg-[#DA9972] transition">Delete</button>
                        <button onclick="toggleStatus(this, 2)" class="px-4 py-2 text-white bg-[#FF5722] rounded-md hover:bg-[#e64a19]">Activate/Deactivate</button>
                    </td>
                </tr>
            </tbody>
                </table>
            </div>
        </div>
    </main>
    <?php include "footer.php";?>
</div>

<!-- Add Reward Modal -->
<div id="add-reward-modal" class="fixed inset-0 flex items-center justify-center bg-gray-900 bg-opacity-50 hidden">
    <div class="bg-white p-6 rounded-lg shadow-lg max-w-lg w-full">
        <h3 class="text-xl font-semibold mb-3">Add Reward</h3>
        <form id="add-reward-form">
            <div class="mb-3">
                <label for="name" class="block text-sm font-medium text-gray-700">Name</label>
                <input type="text" id="name" class="w-full p-2 border border-gray-300 rounded-md" required>
            </div>
            <div class="mb-3">
                <label for="email" class="block text-sm font-medium text-gray-700">Email</label>
                <input type="email" id="email" class="w-full p-2 border border-gray-300 rounded-md" required>
            </div>
            <div class="mb-3">
                <label for="image" class="block text-sm font-medium text-gray-700">Image URL</label>
                <input type="text" id="image" class="w-full p-2 border border-gray-300 rounded-md" required>
            </div>
            <div class="mb-3">
                <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                <textarea id="description" rows="3" class="w-full p-2 border border-gray-300 rounded-md" required></textarea>
            </div>
            <div class="mb-3">
                <label for="ntc" class="block text-sm font-medium text-gray-700">Ntc</label>
                <input type="number" id="ntc" class="w-full p-2 border border-gray-300 rounded-md" required>
            </div>
            <div class="mb-3">
                <label for="min_trade_lot" class="block text-sm font-medium text-gray-700">Min Trade Lot</label>
                <input type="number" id="min_trade_lot" class="w-full p-2 border border-gray-300 rounded-md" required>
            </div>
            <div class="mb-3">
                <label for="min_deposit" class="block text-sm font-medium text-gray-700">Min Deposit</label>
                <input type="number" id="min_deposit" class="w-full p-2 border border-gray-300 rounded-md" required>
            </div>
            <div class="mb-3">
                <label for="total_deposit" class="block text-sm font-medium text-gray-700">Total Deposit</label>
                <input type="number" id="total_deposit" class="w-full p-2 border border-gray-300 rounded-md" required>
            </div>
            <div class="mb-3">
                <label for="total_traded_lots" class="block text-sm font-medium text-gray-700">Total Traded Lots</label>
                <input type="number" id="total_traded_lots" class="w-full p-2 border border-gray-300 rounded-md" required>
            </div>
            <div class="mb-3">
                <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                <select id="status" class="w-full p-2 border border-gray-300 rounded-md">
                    <option value="active">Active</option>
                    <option value="inactive">Inactive</option>
                </select>
            </div>
            <div class="flex justify-end space-x-2">
                <button type="button" onclick="closeAddRewardModal()" class="px-4 py-2 bg-gray-500 text-white rounded-md hover:bg-gray-600">Cancel</button>
                <button type="submit" class="px-4 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600">Add Reward</button>
            </div>
        </form>
    </div>
</div>

<script>
    // Open Add Reward Modal
    function openAddRewardModal() {
        document.getElementById('add-reward-modal').classList.remove('hidden');
    }

    // Close Add Reward Modal
    function closeAddRewardModal() {
        document.getElementById('add-reward-modal').classList.add('hidden');
    }

    // Add Reward Action (Submit form)
    document.getElementById('add-reward-form').addEventListener('submit', function(event) {
        event.preventDefault();

        // Get values from the form
        const name = document.getElementById('name').value;
        const email = document.getElementById('email').value;
        const image = document.getElementById('image').value;
        const description = document.getElementById('description').value;
        const ntc = document.getElementById('ntc').value;
        const minTradeLot = document.getElementById('min_trade_lot').value;
        const minDeposit = document.getElementById('min_deposit').value;
        const totalDeposit = document.getElementById('total_deposit').value;
        const totalTradedLots = document.getElementById('total_traded_lots').value;
        const status = document.getElementById('status').value;

        // Create a new row in the table
        const table = document.getElementById('reward-table-body');
        const newRow = table.insertRow();
        newRow.innerHTML = `
            <td class="p-2 border text-center">${table.rows.length + 1}</td>
            <td class="p-2 border">${name}</td>
            <td class="p-2 border">${email}</td>
            <td class="p-2 border">
                <img src="${image}" alt="${name}'s image" class="w-12 h-12 rounded-full">
            </td>
            <td class="p-2 border">${description}</td>
            <td class="p-2 border">${ntc}</td>
            <td class="p-2 border">${minTradeLot}</td>
            <td class="p-2 border">${minDeposit}</td>
            <td class="p-2 border">${totalDeposit}</td>
            <td class="p-2 border">${totalTradedLots}</td>
            <td class="p-2 border" id="status-${table.rows.length + 1}">${status.charAt(0).toUpperCase() + status.slice(1)}</td>
            <td class="p-2 border flex space-x-2">
                <button onclick="toggleStatus(this, ${table.rows.length + 1})" class="px-4 py-2 text-white bg-[#4CAF50] rounded-md hover:bg-[#45a049]">Activate/Deactivate</button>
            </td>
        `;

        // Close the modal and reset the form
        closeAddRewardModal();
        document.getElementById('add-reward-form').reset();
    });

    // Toggle Reward Status (Active/Inactive)
    function toggleStatus(button, rowIndex) {
        let row = document.getElementById('reward-table-body').rows[rowIndex - 1]; // Correcting for 0-based index
        let statusCell = row.cells[10]; // Get the Status cell
        
        if (statusCell.innerText === "Active") {
            statusCell.innerText = "Inactive";
            statusCell.classList.remove("text-green-600", "bg-green-100");
            statusCell.classList.add("text-red-600", "bg-red-100");
        } else {
            statusCell.innerText = "Active";
            statusCell.classList.remove("text-red-600", "bg-red-100");
            statusCell.classList.add("text-green-600", "bg-green-100");
        }
    }
</script>
</body>
</html>
