<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .btn {
            padding: 5px 10px;
            border: none;
            color: white;
            cursor: pointer;
            border-radius: 5px;
            display: inline-block;
            width: 100%;
            text-align: center;
        }
        .btn a {
            text-decoration: none;
            color: white;
            display: block;
        }
        .open {
            background-color: orange;
        }
        .close {
            background-color: darkorange;
        }
    </style>
    <script>
        function filterTable() {
            let input = document.getElementById("searchInput").value.toLowerCase();
            let table = document.getElementById("dataTable");
            let tr = table.getElementsByTagName("tr");
            
            for (let i = 1; i < tr.length; i++) {
                let td = tr[i].getElementsByTagName("td");
                let found = false;
                for (let j = 0; j < td.length; j++) {
                    if (td[j] && td[j].innerHTML.toLowerCase().indexOf(input) > -1) {
                        found = true;
                        break;
                    }
                }
                tr[i].style.display = found ? "" : "none";
            }
        }
    </script>
</head>
<body class="bg-gray-100">
    <?php include "header.php";?>
    <div class="flex flex-col md:flex-row min-h-screen bg-white">
        <?php include "side_bar.php";?>

        <main class="flex-1 p-6 md:ml-64">
            <div class="container mx-auto bg-white p-4 shadow-lg rounded-lg">
                <div class="flex flex-col md:flex-row justify-between items-center mb-4">
                    <label for="entries" class="mb-2 md:mb-0">
                        Show 
                        <select id="entries" class="border p-2 rounded">
                            <option>10</option>
                            <option>25</option>
                            <option>50</option>
                        </select> entries
                    </label>
                    <input type="text" id="searchInput" placeholder="Search..." onkeyup="filterTable()" class="border p-2 rounded w-full md:w-1/3">
                </div>

                <!-- Responsive Table Wrapper -->
                <div class="overflow-x-auto">
                    <table id="dataTable" class="w-full border-collapse border border-gray-300">
                        <thead class="bg-gray-200">
                            <tr>
                                <th class="border p-2">Name</th>
                                <th class="border p-2">Login</th>
                                <th class="border p-2">Balance</th>
                                <th class="border p-2">Credit</th>
                                <th class="border p-2">EquityPrevDay</th>
                                <th class="border p-2">Equity</th>
                                <th class="border p-2">Floating</th>
                                <th class="border p-2">Net Deposit</th>
                                <th class="border p-2">Current Profit</th>
                                <th class="border p-2">Total Profit</th>
                                <th class="border p-2">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="bg-white hover:bg-gray-100">
                                <td class="border p-2">Contact TS</td>
                                <td class="border p-2">100007484</td>
                                <td class="border p-2">0</td>
                                <td class="border p-2">1000</td>
                                <td class="border p-2">1000</td>
                                <td class="border p-2">1000</td>
                                <td class="border p-2">0</td>
                                <td class="border p-2">0</td>
                                <td class="border p-2">0</td>
                                <td class="border p-2">0</td>
                                <td class="border p-2 flex flex-col space-y-2">
                                    <button class="btn open"><a href="open_position.php">Open Positions</a></button>
                                    <button class="btn close">Close Deals</button>
                                </td>
                            </tr>
                            <tr class="bg-white hover:bg-gray-100">
                                <td class="border p-2">Contact TS</td>
                                <td class="border p-2">105007439</td>
                                <td class="border p-2">1.21</td>
                                <td class="border p-2">0</td>
                                <td class="border p-2">1.21</td>
                                <td class="border p-2">1.21</td>
                                <td class="border p-2">0</td>
                                <td class="border p-2">0</td>
                                <td class="border p-2">0</td>
                                <td class="border p-2">1.21</td>
                                <td class="border p-2 flex flex-col space-y-2">
                                    <button class="btn open">Open Positions</button>
                                    <button class="btn close">Close Deals</button>
                                </td>
                            </tr>
                            <!-- Add more rows dynamically -->
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>
    <?php include "footer.php";?>
</body>
</html>
