<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style>
        /* General Styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 1200px;
            margin: 30px auto;
            padding: 20px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }

        h2 {
            font-size: 28px;
            color: #333;
            text-align: center;
            margin-bottom: 20px;
        }

        /* Table Styling */
        .subadmin-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .subadmin-table th, .subadmin-table td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        .subadmin-table th {
            background-color: #f2f2f2;
            font-size: 18px;
            color: #555;
        }

        .subadmin-table td {
            font-size: 16px;
            color: #333;
        }

        /* Edit Button Styling */
        .edit-btn {
            background-color: #CD7F32;
            color: white;
            padding: 8px 12px;
            font-size: 14px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .edit-btn:hover {
            background-color: #0056b3;
        }

        /* Modal Background */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }

        /* Modal Content */
        .modal-content {
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
            width: 500px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        input, select {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            font-size: 16px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }

        button.submit-btn, button.cancel-btn {
            padding: 10px 20px;
            margin-top: 15px;
            font-size: 16px;
            border-radius: 5px;
            border: none;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        button.submit-btn {
            background-color: #007bff;
            color: white;
        }

        button.submit-btn:hover {
            background-color: #0056b3;
        }

        button.cancel-btn {
            background-color: #f44336;
            color: white;
        }

        button.cancel-btn:hover {
            background-color: #d32f2f;
        }
    </style>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
        <h2>Sub-Admin List</h2>

        <!-- Sub-Admin Table -->
        <table class="subadmin-table" id="subadminTable">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Type</th>
                    <th>Group</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <!-- Data will be dynamically added here -->
            </tbody>
        </table>
    </div></main><?php include "footer.php";?>
    </div>

    <!-- Edit Modal -->
    <div class="modal" id="editModal">
        <div class="modal-content">
            <h3>Edit Sub-Admin</h3>
            <form id="editForm">
                <input type="hidden" id="subadmin_id">
                <div class="form-group">
                    <label for="name">Name:</label>
                    <input type="text" id="name" required>
                </div>
                <div class="form-group">
                    <label for="email">Email:</label>
                    <input type="email" id="email" required>
                </div>
                <div class="form-group">
                    <label for="type">Type:</label>
                    <select id="type" required>
                        <option value="Editor">Editor</option>
                        <option value="Viewer">Viewer</option>
                        <option value="Admin">Admin</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="group">Select Group:</label>
                    <select id="group" required>
                        <option value="Group 1">Group 1</option>
                        <option value="Group 2">Group 2</option>
                        <option value="Group 3">Group 3</option>
                    </select>
                </div>
                <div class="form-group">
                    <button type="submit" class="submit-btn">Update</button>
                    <button type="button" class="cancel-btn" onclick="closeEditModal()">Cancel</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Dummy data for sub-admins
        let subadmins = [
            { id: 1, name: 'John Doe', email: 'johndoe@example.com', type: 'Editor', group: 'Group 1' },
            { id: 2, name: 'Jane Smith', email: 'janesmith@example.com', type: 'Viewer', group: 'Group 2' },
            { id: 3, name: 'Alice Johnson', email: 'alice@example.com', type: 'Admin', group: 'Group 3' }
        ];

        // Function to display sub-admins in the table
        function displaySubAdmins() {
            const tableBody = document.getElementById('subadminTable').getElementsByTagName('tbody')[0];
            tableBody.innerHTML = '';
            subadmins.forEach(subadmin => {
                const row = tableBody.insertRow();
                row.innerHTML = `
                    <td>${subadmin.name}</td>
                    <td>${subadmin.email}</td>
                    <td>${subadmin.type}</td>
                    <td>${subadmin.group}</td>
                    <td><button class='edit-btn' onclick='openEditModal(${subadmin.id})'>Edit</button></td>
                `;
            });
        }

        // Function to open the edit modal and populate the form
        function openEditModal(id) {
            const subadmin = subadmins.find(s => s.id === id);
            document.getElementById('subadmin_id').value = subadmin.id;
            document.getElementById('name').value = subadmin.name;
            document.getElementById('email').value = subadmin.email;
            document.getElementById('type').value = subadmin.type;
            document.getElementById('group').value = subadmin.group;

            // Show the modal
            document.getElementById('editModal').style.display = 'flex';
        }

        // Function to close the edit modal
        function closeEditModal() {
            document.getElementById('editModal').style.display = 'none';
        }

        // Handle the form submission (update sub-admin data)
        document.getElementById('editForm').addEventListener('submit', function(event) {
            event.preventDefault();

            const id = parseInt(document.getElementById('subadmin_id').value);
            const name = document.getElementById('name').value;
            const email = document.getElementById('email').value;
            const type = document.getElementById('type').value;
            const group = document.getElementById('group').value;

            // Find and update the sub-admin
            const subadminIndex = subadmins.findIndex(s => s.id === id);
            if (subadminIndex !== -1) {
                subadmins[subadminIndex] = { id, name, email, type, group };
            }

            // Close the modal and refresh the table
            closeEditModal();
            displaySubAdmins();
        });

        // Initially display sub-admins in the table
        displaySubAdmins();
    </script>
</body>
</html>
