<?php
// Dummy data for the existing groups
$groups = [
    1 => ['group_name' => 'Group 1', 'mt5_group_name' => 'MT5 Group 1', 'status' => 'active'],
    2 => ['group_name' => 'Group 2', 'mt5_group_name' => 'MT5 Group 2', 'status' => 'inactive'],
    3 => ['group_name' => 'Group 3', 'mt5_group_name' => 'MT5 Group 3', 'status' => 'active'],
    4 => ['group_name' => 'Group 4', 'mt5_group_name' => 'MT5 Group 4', 'status' => 'inactive']
];

// Handle form submission to update MT5 Group
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $group_id = $_POST['group_id'];
    $new_mt5_group_name = $_POST['mt5_group_name'];

    // In real-world, update this information in the database. Here we are just showing the updated data.
    echo "Group ID: $group_id, Updated MT5 Group Name: $new_mt5_group_name - MT5 Group updated successfully!";
    exit;
}

// If ID is provided, get the group details
$selected_group = null;
if (isset($_GET['id']) && isset($groups[$_GET['id']])) {
    $selected_group = $groups[$_GET['id']];
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update MT5 Group</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

    <main class="flex-1 p-8 ml-164">
     <div class="container mx-auto mt-10">
        <h1 class="text-3xl font-bold text-center mb-6">Update MT5 Group</h1>

        <?php if ($selected_group): ?>
        <!-- Update MT5 Group Form -->
        <form action="update_mt5_group.php" method="POST" class="max-w-lg mx-auto bg-white p-6 rounded-lg shadow-md">
            
            <!-- Group ID (Hidden) -->
            <input type="hidden" name="group_id" value="<?php echo $_GET['id']; ?>">

            <!-- Group Name (Display) -->
            <div class="mb-6">
                <label for="group_name" class="block text-gray-600 text-lg font-medium mb-2">Group Name:</label>
                <input type="text" id="group_name" name="group_name" value="<?php echo $selected_group['group_name']; ?>" disabled class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-600">
            </div>

            <!-- MT5 Group Name (Editable) -->
            <div class="mb-6">
                <label for="mt5_group_name" class="block text-gray-600 text-lg font-medium mb-2">MT5 Group Name:</label>
                <input type="text" id="mt5_group_name" name="mt5_group_name" value="<?php echo $selected_group['mt5_group_name']; ?>" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-600" required>
            </div>

            <!-- Submit Button -->
            <button type="submit" class="w-full py-3 bg-blue-600 text-white font-semibold rounded-md shadow-md hover:bg-blue-700 transition duration-300">Update MT5 Group</button>
        </form>
        <?php else: ?>
        <p class="text-red-600 text-center">Group not found!</p>
        <?php endif; ?>
    </div>
    <?php include "footer.php";?>
</main>
</div>
</body>
</html>
