<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Management</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<style>/* style.css */
body {
    font-family: Arial, sans-serif;
    background-color: #f4f4f4;
    margin: 0;
    padding: 0;
}
.container {
    width: 80%;
    margin: auto;
    background: #fff;
    padding: 20px;
    box-shadow: 0px 0px 10px 0px #ccc;
    border-radius: 5px;
}
.dashboard-header {
    background: #ff6600;
    color: #fff;
    padding: 15px;
    text-align: center;
    font-size: 24px;
}
.table {
    width: 100%;
    border-collapse: collapse;
    margin: 20px 0;
}
.table th, .table td {
    border: 1px solid #ddd;
    padding: 10px;
    text-align: center;
}
.form-container {
    width: 50%;
    margin: auto;
    background: #fff;
    padding: 20px;
    box-shadow: 0px 0px 10px 0px #ccc;
    border-radius: 5px;
}
.input-group {
    margin: 15px 0;
}
.input-group label {
    display: block;
    margin-bottom: 5px;
}
.input-group input {
    width: 100%;
    padding: 10px;
    border: 1px solid #ccc;
    border-radius: 5px;
}
.button {
    background: #ff6600;
    color: #fff;
    padding: 10px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
}
</style>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>
        <?php //include "header.php";?>
        <!-- Main Content -->
          <main class="flex-1 p-6 md:ml-64">
           
    <div class="container">
        <h2>Add User</h2>
        <form action="process_user.php" method="POST">
            <div class="input-group">
                <label for="name">Name:</label>
                <input type="text" id="name" name="name" required>
            </div>
            <div class="input-group">
                <label for="email">Email:</label>
                <input type="email" id="email" name="email" required>
            </div>
            <div class="input-group">
                <label for="password">Password:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <div class="input-group">
                <label for="country">Country:</label>
                <select id="country" name="country" required>
                    <option value="">Please Choose...</option>
                    <option value="USA">USA</option>
                    <option value="UK">UK</option>
                    <option value="Canada">Canada</option>
                </select>
            </div>
            <button type="submit" class="button">Submit</button>
        </form>
    </div>
    <br><br><br><?php include "footer.php";?>
    
    </main>
    </div>
</body>
</html>
