
<?php
session_start();
include "config.php"; // Ensure this file connects to your database

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}



include "config.php"; // Ensure this file connects to your database
ini_set('display_errors', 1);
error_reporting(E_ALL);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect form data
    $wallet_address = $_POST['wallet_address'];
    $amount = $_POST['amount'];

    // Validate required fields
    if (!empty($wallet_address) && !empty($amount)) {
        try {
            // Prepare SQL query for insertion
            $sql = "INSERT INTO bitcoin_deposits (wallet_address, amount) 
                    VALUES (:wallet_address, :amount)";
            $stmt = $conn->prepare($sql);

            // Bind the parameters
            $stmt->bindParam(':wallet_address', $wallet_address);
            $stmt->bindParam(':amount', $amount);

            // Execute the statement
            if ($stmt->execute()) {
                // Redirect to success page after successful insertion
                header("Location: success_page.php");
                exit();
            } else {
                // Print the error message if insert fails
                print_r($stmt->errorInfo());
            }
        } catch (PDOException $e) {
            // Display error message
            echo "Database error: " . $e->getMessage();
        }
    } else {
        echo "<script>alert('All fields are required.');</script>";
    }
}ob_end_flush();
?>
