<?php
session_start();
include "config.php"; // Ensure this file connects to your database

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}

 // Start output buffering

ini_set('display_errors', 1);
error_reporting(E_ALL);

include "config.php"; // Ensure this file connects to your database

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect form data
    $account_name = $_POST['account_name'];
    $account_number = $_POST['account_number'];
    $amount = $_POST['amount'];
    $comment = $_POST['comment'];

    // Validate required fields
    if (!empty($account_name) && !empty($account_number) && !empty($amount)) {
        try {
            // Prepare SQL query for insertion
            $sql = "INSERT INTO bank_withdraw (account_name, account_number, amount, comment) 
                    VALUES (:account_name, :account_number, :amount, :comment)";
            $stmt = $conn->prepare($sql);
            $stmt->bindParam(':account_name', $account_name);
            $stmt->bindParam(':account_number', $account_number);
            $stmt->bindParam(':amount', $amount);
            $stmt->bindParam(':comment', $comment);

            // Execute the statement
            if ($stmt->execute()) {
                // Redirect to a success page
                header("Location: success_page.php");
                exit();
            } else {
                // If execution fails, display an error
                echo "<script>alert('Error adding deposit.');</script>";
            }
        } catch (PDOException $e) {
            // Display the error if the query fails
            echo "<script>alert('Database error: " . $e->getMessage() . "');</script>";
        }
    } else {
        echo "<script>alert('All fields except comment are required.');</script>";
    }
}

 // Flush the output buffer and send the headers
?>
