<?php
session_start();
include "config.php";

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
    exit();
}

// Display error message if exists
$error = '';
if (isset($_SESSION['error'])) {
    $error = $_SESSION['error'];
    unset($_SESSION['error']);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bank Deposit</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        .error-message {
            color: #ef4444;
            background-color: #fee2e2;
            padding: 1rem;
            margin-bottom: 1.5rem;
            border-radius: 0.375rem;
            border-left: 4px solid #ef4444;
        }
    </style>
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

    <main class="flex-1 p-6 md:ml-64">
        <div class="container mx-auto">
            <h1 class="text-4xl font-bold text-center mb-6 text-[#CD7F32]">Bank Deposit</h1>
            
            <?php if (!empty($error)): ?>
                <div class="error-message max-w-3xl mx-auto">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>
            
            <!-- Deposit Form -->
            <form action="deposit_handler.php" method="POST" class="max-w-3xl mx-auto bg-white p-10 rounded-lg shadow-xl border border-gray-200">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Account Name -->
                    <div>
                        <label for="account_name" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Account Name:</label>
                        <input type="text" id="account_name" name="account_name" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter account name">
                    </div>

                    <!-- Account Number -->
                    <div>
                        <label for="account_number" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Account Number:</label>
                        <input type="text" id="account_number" name="account_number" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter account number">
                    </div>

                    <!-- Amount -->
                    <div>
                        <label for="amount" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Deposit Amount ($):</label>
                        <input type="number" id="amount" name="amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter deposit amount" min="10" step="0.01">
                        <p class="text-sm text-gray-500 mt-1">Minimum deposit: $10</p>
                    </div>

                    <!-- Bank Selection -->
                    <div>
                        <label for="bank_name" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Bank Name:</label>
                        <select id="bank_name" name="bank_name" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required>
                            <option value="">Select your bank</option>
                            <option value="Bank of America">Bank of America</option>
                            <option value="Chase">Chase</option>
                            <option value="Wells Fargo">Wells Fargo</option>
                            <option value="Citibank">Citibank</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>

                    <!-- Comment -->
                    <div class="md:col-span-2">
                        <label for="comment" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Additional Notes:</label>
                        <textarea id="comment" name="comment" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" rows="3" placeholder="Any additional information about your deposit"></textarea>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="mt-8 text-center">
                    <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                        Submit Bank Deposit
                    </button>
                </div>
            </form>
        </div>
    </main>
</div>
<?php include "footer.php"; ?>
</body>
</html>