<?php
session_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);
include "config.php"; // Ensure this file connects to your database

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}

$user_id = $_SESSION['user_id']; // Assuming you store user ID in session

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $method = $_POST['method'];
    $amount = $_POST['amount'];
    $net_amount = $amount;
    
    // Initialize method-specific fields
    $wallet_address = '';
    $bank_name = '';
    $account_name = '';
    $account_number = '';
    $routing_number = '';
    $email = '';
    $network = '';
    $payment_reference = uniqid('DPT'); // Generate unique reference
    
    // Process method-specific fields
    switch ($method) {
        case 'bank_transfer':
            $bank_name = $_POST['bank_name'];
            $account_name = $_POST['account_name'];
            $account_number = $_POST['account_number'];
            $routing_number = $_POST['routing_number'] ?? '';
            break;
            
        case 'usdt':
        case 'bitcoin':
            $wallet_address = $_POST['wallet_address'];
            $network = $_POST['network'] ?? 'TRC20';
            // Crypto might have network fees
            $deposit_fee = 0.00; // Set your fee logic here
            $net_amount = $amount - $deposit_fee;
            break;
            
        case 'paypal':
        case 'neteller':
            $email = $_POST['email'];
            break;
    }
    
    // Insert into database
    $stmt = $conn->prepare("INSERT INTO deposits (
        user_id, deposit_method, amount, transaction_id, wallet_address, 
        bank_name, account_name, account_number, routing_number, 
        email, payment_reference, network, deposit_fee, net_amount
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
    $stmt->bind_param(
        "isdsisssssssdd", 
        $user_id, $method, $amount, $payment_reference, $wallet_address,
        $bank_name, $account_name, $account_number, $routing_number,
        $email, $payment_reference, $network, $deposit_fee, $net_amount
    );
    
    if ($stmt->execute()) {
        // Success - redirect to confirmation or show success message
        $_SESSION['deposit_id'] = $stmt->insert_id;
        header("Location: deposit_success.php");
        exit();
    } else {
        // Error handling
        $error = "Deposit failed. Please try again.";
    }
}


?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deposit Options</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

    <main class="flex-1 p-6 md:ml-64">
        <!-- Top Navigation -->
        <div class="container mx-auto">
            <h1 class="text-4xl font-bold text-center mb-6 text-[#CD7F32]">Choose Deposit Method</h1>

            <!-- Tabs for Switching Between Deposit Methods -->
            <div class="flex justify-center space-x-6 mb-8">
                <button id="bitcoin-tab" class="px-6 py-3 text-lg font-semibold text-[#CD7F32] border-b-2 border-[#CD7F32] hover:bg-[#CD7F32] hover:text-white transition duration-300" onclick="showTab('bitcoin')">
                    Bitcoin Deposit
                </button>
                <button id="usdt-tab" class="px-6 py-3 text-lg font-semibold text-[#CD7F32] hover:bg-[#CD7F32] hover:text-white transition duration-300" onclick="showTab('usdt')">
                    USDT Deposit
                </button>
                <button id="neteller-tab" class="px-6 py-3 text-lg font-semibold text-[#CD7F32] hover:bg-[#CD7F32] hover:text-white transition duration-300" onclick="showTab('neteller')">
                    Neteller Deposit
                </button>
                <button id="paypal-tab" class="px-6 py-3 text-lg font-semibold text-[#CD7F32] hover:bg-[#CD7F32] hover:text-white transition duration-300" onclick="showTab('paypal')">
                    PayPal Deposit
                </button>
                <button id="bank-tab" class="px-6 py-3 text-lg font-semibold text-[#CD7F32] hover:bg-[#CD7F32] hover:text-white transition duration-300" onclick="showTab('bank')">
                    Bank Deposit
                </button>
            </div>

            <!-- Deposit Forms -->
            <!-- Bitcoin Form -->
            <div id="bitcoin-form" class="tab-content max-w-3xl mx-auto bg-white p-10 rounded-lg shadow-xl border border-gray-200 hidden">
                <h2 class="text-2xl font-bold text-center mb-6 text-[#CD7F32]">Bitcoin Deposit</h2>
                <form action="add_deposits.php" method="POST">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="wallet_address" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Wallet Address:</label>
                            <input type="text" id="wallet_address" name="wallet_address" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter wallet address">
                        </div>
                        <div>
                            <label for="amount" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Deposit Amount:</label>
                            <input type="number" id="amount" name="amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter deposit amount" min="1">
                        </div>
                    </div>
                    <div class="mt-8 text-center">
                        <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                            Add Bitcoin Deposit
                        </button>
                    </div>
                </form>
            </div>

            <!-- USDT Form -->
                        <div id="usdt-form" class="tab-content max-w-3xl mx-auto bg-white p-10 rounded-lg shadow-xl border border-gray-200 hidden">
                <h2 class="text-2xl font-bold text-center mb-6 text-[#CD7F32]">USDT Deposit</h2>
                <form action="add_deposits.php" method="POST">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="wallet_address" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Wallet Address:</label>
                            <input type="text" id="wallet_address" name="wallet_address" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter wallet address">
                        </div>
                        <div>
                            <label for="amount" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Deposit Amount:</label>
                            <input type="number" id="amount" name="amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter deposit amount" min="1">
                        </div>
                    </div>
                    <div class="mt-8 text-center">
                        <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                            Add USDT Deposit
                        </button>
                    </div>
                </form>
            </div>


            <!-- Neteller Form -->
            <div id="neteller-form" class="tab-content max-w-3xl mx-auto bg-white p-10 rounded-lg shadow-xl border border-gray-200 hidden">
                <h2 class="text-2xl font-bold text-center mb-6 text-[#CD7F32]">Neteller Deposit</h2>
                <form action="add_deposits.php" method="POST">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="neteller_email" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Neteller Wallet address:</label>
                            <input type="text" id="wallet_address" name="wallet_address" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter Neteller email address">
                        </div>
                        <div>
                            <label for="neteller_amount" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Deposit Amount:</label>
                            <input type="number" id="neteller_amount" name="neteller_amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter deposit amount" min="1">
                        </div>
                    </div>
                    <div class="mt-8 text-center">
                        <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                            Add Neteller Deposit
                        </button>
                    </div>
                </form>
            </div>

            <!-- PayPal Form -->
            <div id="paypal-form" class="tab-content max-w-3xl mx-auto bg-white p-10 rounded-lg shadow-xl border border-gray-200 hidden">
                <h2 class="text-2xl font-bold text-center mb-6 text-[#CD7F32]">PayPal Deposit</h2>
                <form action="add_deposits.php" method="POST">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="paypal_email" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">PayPal Email:</label>
                            <input type="email" id="paypal_email" name="paypal_email" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter PayPal email address">
                        </div>
                        <div>
                            <label for="paypal_amount" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Deposit Amount:</label>
                            <input type="number" id="paypal_amount" name="paypal_amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter deposit amount" min="1">
                        </div>
                    </div>
                    <div class="mt-8 text-center">
                        <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                            Add PayPal Deposit
                        </button>
                    </div>
                </form>
            </div>

            <!-- Bank Form -->
            <div id="bank-form" class="tab-content max-w-3xl mx-auto bg-white p-10 rounded-lg shadow-xl border border-gray-200 hidden">
                <h2 class="text-2xl font-bold text-center mb-6 text-[#CD7F32]">Bank Deposit</h2>
                <form action="add_deposits.php" method="POST" class="max-w-3xl mx-auto bg-white p-10 rounded-lg shadow-xl border border-gray-200">
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Account Name -->
                        <div>
                            <label for="account_name" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Account Name:</label>
                            <input type="text" id="account_name" name="account_name" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter account name">
                        </div>

                        <!-- Account Number -->
                        <div>
                            <label for="account_number" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Account Number:</label>
                            <input type="text" id="account_number" name="account_number" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter account number">
                        </div>

                        <!-- Amount -->
                        <div>
                            <label for="amount" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Deposit Amount:</label>
                            <input type="number" id="amount" name="amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter deposit amount" min="1">
                        </div>

                        <!-- Comment -->
                        <div>
                            <label for="comment" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Comment:</label>
                            <textarea id="comment" name="comment" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" rows="4" placeholder="Optional comment"></textarea>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="mt-8 text-center">
                        <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                            Add Bank Deposit
                        </button>
                    </div>
                </form>
            </div>

        </div>
    </main>
</div>

<script>
    // Switch between tabs
    function showTab(tab) {
        // Hide all forms
        document.querySelectorAll('.tab-content').forEach(function(form) {
            form.classList.add('hidden');
        });
        // Show the selected form
        document.getElementById(tab + '-form').classList.remove('hidden');
    }

    // Set the default tab
    document.getElementById('bitcoin-tab').classList.add('border-b-2');
    showTab('bitcoin');
</script>
</body>
</html>
