<?php
session_start();
include "config.php";

if (strlen($_SESSION['clogin']) == 0) {
    header('Content-Type: application/json');
    echo json_encode(["error" => "Unauthorized"]);
    exit;
}

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $sql = "SELECT * FROM liveaccount WHERE id = ?";
    $query = $conn->prepare($sql);
    $query->execute([$id]);
    $result = $query->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        header('Content-Type: application/json');
        echo json_encode([
            'mt5_id' => $result['trade_id'],
            'balance' => number_format($result['Balance'], 2),
            'profit' => '0.00', // Update with actual column if available
            'equity' => '0.00'  // Update with actual column if available
        ]);
    } else {
        header('Content-Type: application/json');
        echo json_encode(["error" => "No account found"]);
    }
} else {
    header('Content-Type: application/json');
    echo json_encode(["error" => "No ID provided"]);
}
?>