<?php

require_once 'dbconfig.php';

class USER
{
    private $conn;

    public function __construct()
    {
        $database = new Database();
        $db = $database->dbConnection();
        $this->conn = $db;
    }

    // Function to run queries
    public function runQuery($sql)
    {
        $stmt = $this->conn->prepare($sql);
        return $stmt;
    }

    // Function to get last inserted ID
    public function lasdID()
    {
        return $this->conn->lastInsertId();
    }

    // Registration method without referral
    public function register($email, $upass, $mobileno, $username, $fullname, $country, $code)
    {
        try
        {
            $password = $upass; // Assuming you are not hashing the password (recommended to use password_hash)
            $uid = uniqid();
            $wallet_address = substr(uniqid(true), 6, 5);

            // Insert into aspnetusers table
            $stmt1 = $this->conn->prepare("INSERT INTO aspnetusers(uid, email, password, number, username, fullname, country, emailToken, wallet_address) 
                                           VALUES(:uid, :user_mail, :user_pass, :mobileno, :username, :fullname, :country, :active_code, :wallet_address)");
            $stmt1->bindparam(":uid", $uid);
            $stmt1->bindparam(":user_mail", $email);
            $stmt1->bindparam(":user_pass", $password);
            $stmt1->bindparam(":mobileno", $mobileno);
            $stmt1->bindparam(":username", $username);
            $stmt1->bindparam(":fullname", $fullname);
            $stmt1->bindparam(":country", $country);
            $stmt1->bindparam(":active_code", $code);
            $stmt1->bindparam(":wallet_address", $wallet_address);
            $stmt1->execute();

            // Insert into ib1 table
            $stmt2 = $this->conn->prepare("INSERT INTO ib1(uid, email, password, number, username, name, country, emailToken) 
                                           VALUES(:uid, :user_mail, :user_pass, :mobileno, :username, :fullname, :country, :active_code)");
            $stmt2->bindparam(":uid", $uid);
            $stmt2->bindparam(":user_mail", $email);
            $stmt2->bindparam(":user_pass", $password);
            $stmt2->bindparam(":mobileno", $mobileno);
            $stmt2->bindparam(":username", $username);
            $stmt2->bindparam(":fullname", $fullname);
            $stmt2->bindparam(":country", $country);
            $stmt2->bindparam(":active_code", $code);
            $stmt2->execute();

            return true; // Both queries succeeded
        }
        catch (PDOException $ex)
        {
            echo $ex->getMessage();
            return false; // Error occurred
        }
    }

    // Registration method with referral
    public function register1($email, $upass, $mobileno, $username, $fullname, $country, $code, $ref_email)
    {
        try
        {
            $password = $upass; // Assuming you are not hashing the password (recommended to use password_hash)
            $uid = uniqid();
            $wallet_address = substr(uniqid(true), 6, 5);

            // Insert into aspnetusers table with referral email
            $stmt1 = $this->conn->prepare("INSERT INTO aspnetusers(uid, email, password, number, username, fullname, country, emailToken, wallet_address, ib1) 
                                           VALUES(:uid, :user_mail, :user_pass, :mobileno, :username, :fullname, :country, :active_code, :wallet_address, :ref_email)");
            $stmt1->bindparam(":uid", $uid);
            $stmt1->bindparam(":user_mail", $email);
            $stmt1->bindparam(":user_pass", $password);
            $stmt1->bindparam(":mobileno", $mobileno);
            $stmt1->bindparam(":username", $username);
            $stmt1->bindparam(":fullname", $fullname);
            $stmt1->bindparam(":country", $country);
            $stmt1->bindparam(":active_code", $code);
            $stmt1->bindparam(":wallet_address", $wallet_address);
            $stmt1->bindparam(":ref_email", $ref_email);
            $stmt1->execute();

            // Insert into ib1 table
            $stmt2 = $this->conn->prepare("INSERT INTO ib1(uid, email, password, number, username, name, country, emailToken) 
                                           VALUES(:uid, :user_mail, :user_pass, :mobileno, :username, :fullname, :country, :active_code)");
            $stmt2->bindparam(":uid", $uid);
            $stmt2->bindparam(":user_mail", $email);
            $stmt2->bindparam(":user_pass", $password);
            $stmt2->bindparam(":mobileno", $mobileno);
            $stmt2->bindparam(":username", $username);
            $stmt2->bindparam(":fullname", $fullname);
            $stmt2->bindparam(":country", $country);
            $stmt2->bindparam(":active_code", $code);
            $stmt2->execute();

            return true; // Both queries succeeded
        }
        catch (PDOException $ex)
        {
            echo $ex->getMessage();
            return false; // Error occurred
        }
    }

    // User login
    public function login($email, $upass)
    {
        try
        {
            $stmt = $this->conn->prepare("SELECT * FROM tbl_users WHERE userEmail = :email_id");
            $stmt->execute(array(":email_id" => $email));
            $userRow = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($stmt->rowCount() == 1)
            {
                if ($userRow['userStatus'] == "Y")
                {
                    // Assuming you're storing passwords in plain text (recommend hashing and using password_verify)
                    if ($userRow['userPass'] == md5($upass))
                    {
                        $_SESSION['userSession'] = $userRow['userID'];
                        return true;
                    }
                    else
                    {
                        header("Location: index.php?error");
                        exit;
                    }
                }
                else
                {
                    header("Location: index.php?inactive");
                    exit;
                }
            }
            else
            {
                header("Location: index.php?error");
                exit;
            }
        }
        catch (PDOException $ex)
        {
            echo $ex->getMessage();
        }
    }

    // Check if user is logged in
    public function is_logged_in()
    {
        return isset($_SESSION['userSession']);
    }

    // Redirect method
    public function redirect($url)
    {
        header("Location: $url");
    }

    // Logout method
    public function logout()
    {
        session_destroy();
        unset($_SESSION['userSession']);
        return true;
    }
}
