<?php
session_start();
include('config.php');

// Check if credentials are passed in the URL (GET method)
if (isset($_GET['email']) && isset($_GET['password'])) {
    // Get credentials from URL
    $uname = $_GET['email'];
    $password = $_GET['password'];
} elseif (isset($_POST['signin'])) {
    // Fallback to POST data if URL parameters are not available
    $uname = $_POST['username'];
    $password = $_POST['password'];
} else {
    $msg = "Please provide login credentials.";
}

// Check if the credentials are provided
if (isset($uname) && isset($password)) {
    // Check credentials in the database
    $sql = "SELECT email, password FROM aspnetusers WHERE email=:uname and password=:password and email_confirmed=1";
    $query = $dbh->prepare($sql);
    $query->bindParam(':uname', $uname, PDO::PARAM_STR);
    $query->bindParam(':password', $password, PDO::PARAM_STR);
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_OBJ);

    if ($query->rowCount() > 0) {
        $_SESSION['clogin'] = $uname;  // Set session for the user
        echo "<script type='text/javascript'>document.location ='dashboard';</script>";

        // Fetch country and IP
        $json = @file_get_contents("http://ip-api.com/json/");
        if ($json === FALSE) {
            $country = 'Unknown';
            $ip = $_SERVER['REMOTE_ADDR']; // Fallback to server-side IP
        } else {
            $data = json_decode($json);
            $country = isset($data->country) ? $data->country : 'Unknown';
            $ip = isset($data->IPv4) ? $data->IPv4 : $_SERVER['REMOTE_ADDR'];
        }

        // Debugging: Check the country value
        echo "Country: " . $country . "<br>";

        // Date when the login was made
        $created_date_js = $_POST['reg_date_js'] ?? date('Y-m-d H:i:s'); // Default to current date-time if not provided

        $action = 'login';
        $status = 1;
        $email = $_SESSION['clogin'];

        // Insert into login history
        $sql = "INSERT INTO login_history(email, ip, country, action, created_date_js, status)
                VALUES(:email, :ip, :country, :action, :created_date_js, :status)";
        $query = $dbh->prepare($sql);
        $query->bindParam(':email', $email, PDO::PARAM_STR);
        $query->bindParam(':ip', $ip, PDO::PARAM_STR);
        $query->bindParam(':country', $country, PDO::PARAM_STR);
        $query->bindParam(':action', $action, PDO::PARAM_STR);
        $query->bindParam(':created_date_js', $created_date_js, PDO::PARAM_STR);
        $query->bindParam(':status', $status, PDO::PARAM_STR);
        $query->execute();
    } else {
        $msg = "Your login details are invalid or email is not verified.";
        
    }
}
?>

<!doctype html>
<html lang="en" dir="ltr">
  <head>
  
  <?php include 'title.php';?>

  </head>
  <body class=" " data-bs-spy="scroll" data-bs-target="#elements-section" data-bs-offset="0" tabindex="0">
    <!-- loader Start -->
    <div id="loading">
      <div class="loader simple-loader">
          <div class="loader-body"></div>
      </div>    </div>
    <!-- loader END -->
    
      <div class="wrapper">
      <section class="login-content">
         <div class="row m-0 align-items-center bg-white vh-100">            
            <div class="col-md-6">
               <div class="row justify-content-center">
                  <div class="col-md-10">
                     <div class="card card-transparent shadow-none d-flex justify-content-center mb-0 auth-card">
                        <div class="card-body">
                           <a href="index.php" class="navbar-brand d-flex align-items-center mb-3">
                              <!--Logo start-->
                              <!--logo End-->
                              
                              <!--Logo start-->
                              <!--<div class="logo-main">-->
                              <!--    <div class="logo-normal">-->
                              <!--        <svg class="text-primary icon-30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">-->
                              <!--            <rect x="-0.757324" y="19.2427" width="28" height="4" rx="2" transform="rotate(-45 -0.757324 19.2427)" fill="currentColor"/>-->
                              <!--            <rect x="7.72803" y="27.728" width="28" height="4" rx="2" transform="rotate(-45 7.72803 27.728)" fill="currentColor"/>-->
                              <!--            <rect x="10.5366" y="16.3945" width="16" height="4" rx="2" transform="rotate(45 10.5366 16.3945)" fill="currentColor"/>-->
                              <!--            <rect x="10.5562" y="-0.556152" width="28" height="4" rx="2" transform="rotate(45 10.5562 -0.556152)" fill="currentColor"/>-->
                              <!--        </svg>-->
                              <!--    </div>-->
                              <!--    <div class="logo-mini">-->
                              <!--        <svg class="text-primary icon-30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">-->
                              <!--            <rect x="-0.757324" y="19.2427" width="28" height="4" rx="2" transform="rotate(-45 -0.757324 19.2427)" fill="currentColor"/>-->
                              <!--            <rect x="7.72803" y="27.728" width="28" height="4" rx="2" transform="rotate(-45 7.72803 27.728)" fill="currentColor"/>-->
                              <!--            <rect x="10.5366" y="16.3945" width="16" height="4" rx="2" transform="rotate(45 10.5366 16.3945)" fill="currentColor"/>-->
                              <!--            <rect x="10.5562" y="-0.556152" width="28" height="4" rx="2" transform="rotate(45 10.5562 -0.556152)" fill="currentColor"/>-->
                              <!--        </svg>-->
                              <!--    </div>-->
                              <!--</div>-->
                              <!--logo End-->
                              
                              
                              
                              
                           </a>
                           <h2 class="mb-2 text-center">Sign In</h2>
                           <p class="text-center">  <?php if (isset($msg)) echo $msg; ?></p>
                           <form action="" method="POST">
                              <div class="row">
                                 <div class="col-lg-12">
                                    <div class="form-group">
                                       <label for="email" class="form-label">Email</label>
                                       <input type="email" class="form-control" id="email" name="username" aria-describedby="email" placeholder=" ">
                                    </div>
                                 </div>
                                 <div class="col-lg-12">
                                    <div class="form-group">
                                       <label for="password" class="form-label">Password</label>
                                       <input type="password" class="form-control" id="password" name="password"  aria-describedby="password" placeholder=" ">
                                    </div>
                                 </div>
                                 <div class="col-lg-12 d-flex justify-content-between">
                                    <div class="form-check mb-3">
                                       <input type="checkbox" class="form-check-input" id="customCheck1">
                                       <label class="form-check-label" for="customCheck1">Remember Me</label>
                                    </div>
                                    <a href="forgot_password.php">Forgot Password?</a>
                                 </div>
                              </div>
                              <div class="d-flex justify-content-center">
                                 <button type="submit" class="btn btn-primary" name="signin" >Sign In</button>
                              </div>
                              <!--<p class="text-center my-3">or sign in with other accounts?</p>-->
                              <!--<div class="d-flex justify-content-center">-->
                              <!--   <ul class="list-group list-group-horizontal list-group-flush">-->
                              <!--      <li class="list-group-item border-0 pb-0">-->
                              <!--         <a href="#"><img src="assets/images/brands/fb.svg" alt="fb"></a>-->
                              <!--      </li>-->
                              <!--      <li class="list-group-item border-0 pb-0">-->
                              <!--         <a href="#"><img src="assets/images/brands/gm.svg" alt="gm"></a>-->
                              <!--      </li>-->
                              <!--      <li class="list-group-item border-0 pb-0">-->
                              <!--         <a href="#"><img src="assets/images/brands/im.svg" alt="im"></a>-->
                              <!--      </li>-->
                              <!--      <li class="list-group-item border-0 pb-0">-->
                              <!--         <a href="#"><img src="assets/images/brands/li.svg" alt="li"></a>-->
                              <!--      </li>-->
                              <!--   </ul>-->
                              <!--</div>-->
                              <p class="mt-3 text-center">
                                 Don’t have an account? <a href="register.php" class="text-underline">Click here to sign up.</a>
                              </p>
                           </form>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="sign-bg">
                  <svg width="280" height="230" viewBox="0 0 431 398" fill="none" xmlns="http://www.w3.org/2000/svg">
                     <g opacity="0.05">
                     <rect x="-157.085" y="193.773" width="543" height="77.5714" rx="38.7857" transform="rotate(-45 -157.085 193.773)" fill="#3B8AFF"/>
                     <rect x="7.46875" y="358.327" width="543" height="77.5714" rx="38.7857" transform="rotate(-45 7.46875 358.327)" fill="#3B8AFF"/>
                     <rect x="61.9355" y="138.545" width="310.286" height="77.5714" rx="38.7857" transform="rotate(45 61.9355 138.545)" fill="#3B8AFF"/>
                     <rect x="62.3154" y="-190.173" width="543" height="77.5714" rx="38.7857" transform="rotate(45 62.3154 -190.173)" fill="#3B8AFF"/>
                     </g>
                  </svg>
               </div>
            </div>
            <div class="col-md-6 d-md-block d-none bg-primary p-0 mt-n1 vh-100 overflow-hidden">
               <img src="assets/images/auth/01.png" class="img-fluid gradient-main animated-scaleX" alt="images">
            </div>
         </div>
      </section>
      </div>
    
    <!-- Library Bundle Script -->
    <script src="assets/js/core/libs.min.js"></script>
    
    <!-- External Library Bundle Script -->
    <script src="assets/js/core/external.min.js"></script>
    
    <!-- Widgetchart Script -->
    <script src="assets/js/charts/widgetcharts.js"></script>
    
    <!-- mapchart Script -->
    <script src="assets/js/charts/vectore-chart.js"></script>
    <script src="assets/js/charts/dashboard.js" ></script>
    
    <!-- fslightbox Script -->
    <script src="assets/js/plugins/fslightbox.js"></script>
    
    <!-- Settings Script -->
    <script src="assets/js/plugins/setting.js"></script>
    
    <!-- Slider-tab Script -->
    <script src="assets/js/plugins/slider-tabs.js"></script>
    
    <!-- Form Wizard Script -->
    <script src="assets/js/plugins/form-wizard.js"></script>
    
    <!-- AOS Animation Plugin-->
    
    <!-- App Script -->
    <script src="assets/js/hope-ui.js" defer></script>
   
  </body>
</html>