<?php session_start();
include('config.php');
include 'manager_initialize.php';
include 'title.php';

if (isset($_POST['verify_otp']) && isset($_SESSION['otp'])) {
    $enteredOTP = filter_input(INPUT_POST, 'otp', FILTER_SANITIZE_STRING);
    $sessionOTP = $_SESSION['otp'];

    if ($enteredOTP === $sessionOTP) {
        // Collect input using POST for safety
        $email               = filter_input(INPUT_GET, 'email', FILTER_SANITIZE_EMAIL);
        $ifsc                = filter_input(INPUT_GET, 'ifsc', FILTER_SANITIZE_STRING);
        $client_bank         = filter_input(INPUT_GET, 'client_bank', FILTER_SANITIZE_STRING);
        $withdraw_amount     = filter_input(INPUT_GET, 'trading_withdrawal', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
        $account_holder_name = filter_input(INPUT_GET, 'account_holder_name', FILTER_SANITIZE_STRING);
        $account_number      = filter_input(INPUT_GET, 'account_number', FILTER_SANITIZE_STRING);
        $withdraw_type       = filter_input(INPUT_GET, 'withdraw_type', FILTER_SANITIZE_STRING);

        $type = "Bank IB Withdraw"; // You want to insert this
        $status = "0";
        $adminremark = "IB Withdrawal Request Received";
        $withdraw_date = date('Y-m-d H:i:s'); // ✅ Define this

        $random = rand(11111111,99999999);
        // Insert into ib_withdraw
        $sql2 = "INSERT INTO ib_withdraw (email, withdraw_amount, account_number, withdraw_type,client_bank, AdminRemark, Status, withdraw_date, type, random)
                 VALUES (:email, :withdraw_amount, :account_number, :withdraw_type,:client_bank, :adminremark, :status, :withdraw_date, :type, :random)";
        $stmt2 = $dbh->prepare($sql2);

        $stmt2->bindParam(':email', $email);
        $stmt2->bindParam(':withdraw_amount', $withdraw_amount);
        $stmt2->bindParam(':account_number', $account_number);
        $stmt2->bindParam(':withdraw_type', $withdraw_type);
                $stmt2->bindParam(':client_bank', $client_bank);
                $stmt2->bindParam(':random', $random);

        $stmt2->bindParam(':adminremark', $adminremark);
        $stmt2->bindParam(':status', $status);
        $stmt2->bindParam(':withdraw_date', $withdraw_date);
        $stmt2->bindParam(':type', $type); // ✅ Properly bound
        
        $sql4 = "INSERT INTO wallet_withdraw (email, withdraw_amount, client_bank, withdraw_type, AdminRemark, Status, withdraw_date, random)
                 VALUES (:email, :withdraw_amount, :client_bank, :withdraw_type, :adminremark, :status, :withdraw_date, :random)";
        $stmt4 = $dbh->prepare($sql4);

        $stmt4->bindParam(':email', $email);
        $stmt4->bindParam(':withdraw_amount', $withdraw_amount);
        $stmt4->bindParam(':client_bank', $client_bank);
        $stmt4->bindParam(':withdraw_type', $withdraw_type);

        $stmt4->bindParam(':adminremark', $adminremark);
        $stmt4->bindParam(':status', $status);
        $stmt4->bindParam(':withdraw_date', $withdraw_date);
                $stmt4->bindParam(':random', $random);

        try {
            if ($stmt2->execute() && $stmt4->execute()) {
                echo "<script>window.location.href='withdraw_message.php';</script>";
                exit();
            } else {
                echo "Insert failed.";
            }
        } catch (PDOException $e) {
            echo "Database error: " . htmlspecialchars($e->getMessage());
        }
    } else {
        echo "Invalid OTP. Please try again.";
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>OTP Verification</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Modal -->
<div class="modal fade" id="otpModal" tabindex="-1" aria-labelledby="otpModalLabel" aria-hidden="true" data-bs-backdrop="static">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header"  style="background: radial-gradient(circle, #ffb300, #b8860b); color: white;">
        <h5 class="modal-title" id="otpModalLabel"  style="color: white;"><b>OTP Verification</b></h5>
<button type="button" data-bs-dismiss="modal" id="closeFirstModal" aria-label="Close" 
        style="color:white;background-color:transparent;border:none;font-size:30px">
    <span style="font-size:26px">&times;</span>
</button>      </div>
      <div class="modal-body">
        <form id="otpForm" action="" method="POST">
          <div class="mb-3">
            <label for="otpInput" class="form-label">OTP</label>
            <input type="text" class="form-control" name="otp" id="otpInput" placeholder="******" required>
          </div>
          <button type="submit" class="btn btn-primary w-100" name="verify_otp" style="background: radial-gradient(circle, #ffb300, #b8860b); color: white;"><b>Verify</b></button>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap JS (with Popper) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>

<script>
  // Trigger the modal to open automatically after the page loads
  window.addEventListener('DOMContentLoaded', (event) => {
    var myModal = new bootstrap.Modal(document.getElementById('otpModal'), {
      keyboard: false
    });
    myModal.show();
  });
</script>

</body>
</html>
