<?php
session_start();
include('config.php');

$trade_id = $_GET['tradeid'];

include 'manager_initialize.php'; 

include 'title.php'; 

if (isset($_POST['verify_otp'])) {
    $enteredOTP = filter_input(INPUT_POST, 'otp', FILTER_SANITIZE_STRING);
    $sessionOTP = $_SESSION['otp'];

    if ($enteredOTP === $sessionOTP) {
        // OTP is correct, proceed to insert data
        $email = filter_input(INPUT_GET, 'email', FILTER_SANITIZE_EMAIL);
        $ifsc = filter_input(INPUT_GET, 'ifsc', FILTER_SANITIZE_STRING);
        $client_bank = filter_input(INPUT_GET, 'client_bank', FILTER_SANITIZE_STRING);
        $withdraw_amount = filter_input(INPUT_GET, 'withdraw_amount', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
        $account_holder_name = filter_input(INPUT_GET, 'account_holder_name', FILTER_SANITIZE_STRING);
        $account_number = filter_input(INPUT_GET, 'account_number', FILTER_SANITIZE_STRING);
        $withdraw_type = filter_input(INPUT_GET, 'withdraw_type', FILTER_SANITIZE_STRING);

        $trade_id = filter_input(INPUT_GET, 'tradeid', FILTER_SANITIZE_STRING);


        // Prepare SQL statement to insert data into wallet_withdraw table
        $sql = "INSERT INTO wallet_withdraw (email, client_bank, withdraw_amount, account_holder_name, account_number, withdraw_type, ifsc, trade_id) 
                VALUES (:email, :client_bank, :withdraw_amount, :account_holder_name, :account_number, :withdraw_type, :ifsc, :tradeid)";
        $stmt = $dbh->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':client_bank', $client_bank);
        $stmt->bindParam(':withdraw_amount', $withdraw_amount);
        $stmt->bindParam(':account_holder_name', $account_holder_name);
        $stmt->bindParam(':account_number', $account_number);
        $stmt->bindParam(':withdraw_type', $withdraw_type);
        $stmt->bindParam(':ifsc', $ifsc);
        $stmt->bindParam(':tradeid', $trade_id);

        try {
            // Execute the statement
            if ($stmt->execute()) {
                // Update API balance before redirection
                
    $comment = "Withdraw"; // Set a comment for the transaction
    $type = MTEnDealAction::DEAL_BALANCE; // Type for balance change

      if (($error_code = $api->UserDepositChange($trade_id, -$withdraw_amount, $comment, $type)) != MTRetCode::MT_RET_OK) {
        echo "Error making deduction: " . $error_code;
        exit;
    } else {
        //echo "Money added to MT5 account successfully.";
    }
                
                

                // Redirect to withdraw-message.php
               echo "<script>window.location.href='withdraw_message.php';</script>";
                exit();
            } else {
                $errorInfo = $stmt->errorInfo();
                echo "Error executing query: " . $errorInfo[2];
            }
        } catch (PDOException $e) {
            echo "Database error: " . $e->getMessage();
        }
    } else {
        echo "Invalid OTP. Please try again.";
    }
}
?>




<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>OTP Verification</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Modal -->
<div class="modal fade" id="otpModal" tabindex="-1" aria-labelledby="otpModalLabel" aria-hidden="true" data-bs-backdrop="static">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header"  style="background: radial-gradient(circle, #ffb300, #b8860b); color: white;">
        <h5 class="modal-title" id="otpModalLabel"  style="color: white;"><b>OTP Verification</b></h5>
<button type="button" data-bs-dismiss="modal" id="closeFirstModal" aria-label="Close" 
        style="color:white;background-color:transparent;border:none;font-size:30px">
    <span style="font-size:26px">&times;</span>
</button>      </div>
      <div class="modal-body">
        <form id="otpForm" action="" method="POST">
          <div class="mb-3">
            <label for="otpInput" class="form-label">OTP</label>
            <input type="text" class="form-control" name="otp" id="otpInput" placeholder="******" required>
          </div>
          <button type="submit" class="btn btn-primary w-100" name="verify_otp" style="background: radial-gradient(circle, #ffb300, #b8860b); color: white;"><b>Verify</b></button>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap JS (with Popper) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>

<script>
  // Trigger the modal to open automatically after the page loads
  window.addEventListener('DOMContentLoaded', (event) => {
    var myModal = new bootstrap.Modal(document.getElementById('otpModal'), {
      keyboard: false
    });
    myModal.show();
  });
</script>

</body>
</html>
