<?php
session_start();
include('config.php');

include 'manager_initialize.php';



if (isset($_POST['verify_otp'])) {
    $enteredOTP = filter_input(INPUT_POST, 'otp', FILTER_SANITIZE_STRING);
    $sessionOTP = $_SESSION['otp'];

    if ($enteredOTP === $sessionOTP) {
        // OTP is correct, proceed to insert data
        $email = filter_input(INPUT_GET, 'email', FILTER_SANITIZE_EMAIL);
        $client_bank = filter_input(INPUT_GET, 'client_bank', FILTER_SANITIZE_STRING);
        $withdraw_amount = filter_input(INPUT_GET, 'withdraw_amount', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
        $withdraw_type = filter_input(INPUT_GET, 'withdraw_type', FILTER_SANITIZE_STRING);
        $tradeid = filter_input(INPUT_GET, 'tradeid', FILTER_SANITIZE_STRING);
        
   

        // Prepare SQL statement to insert data into wallet_withdraw table
        $sql = "INSERT INTO wallet_withdraw (email, client_bank, withdraw_amount, withdraw_type, trade_id) 
                VALUES (:email, :client_bank, :withdraw_amount,:withdraw_type,:tradeid)";
        $stmt = $dbh->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':client_bank', $client_bank);
        $stmt->bindParam(':withdraw_amount', $withdraw_amount);
        $stmt->bindParam(':withdraw_type', $withdraw_type);
        $stmt->bindParam(':tradeid', $tradeid);


        try {
            // Execute the statement
            if ($stmt->execute()) {
                
                
    $comment = "Withdrawal request"; // Set a comment for the transaction
    $type = MTEnDealAction::DEAL_BALANCE; // Type for balance change

      if (($error_code = $api->UserDepositChange($tradeid, -$withdraw_amount, $comment, $type)) != MTRetCode::MT_RET_OK) {
        echo "Error making deduction: " . $error_code;
        exit;
    } else {
        //echo "Money added to MT5 account successfully.";
    }
                
                // Redirect to dashboard.php
               echo "<script>window.location.href='withdraw_message.php';</script>";
                exit();
            } else {
                $errorInfo = $stmt->errorInfo();
                echo "Error executing query: " . $errorInfo[2];
            }
        } catch (PDOException $e) {
            echo "Database error: " . $e->getMessage();
        }
    } else {
        echo "Invalid OTP. Please try again.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OTP Verification</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OTP Verification</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* Custom styles for modal */
        .modal-content {
            background-color: #f8f9fa;
            border-radius: 0.5rem;
        }

        .modal-header {
            border-bottom: 1px solid #dee2e6;
        }

        .modal-footer {
            border-top: 1px solid #dee2e6;
        }

        /* Custom button styles */
        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
        }

        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #004085;
        }
    </style>
</head>
<body>

<!-- Modal -->
<div class="modal fade" id="otpModal" tabindex="-1" role="dialog" aria-labelledby="otpModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="otpModalLabel">OTP Verification</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="post" action="">
                    <div class="form-group">
                        <label for="otp">Enter OTP:</label>
                        <input type="text" id="otp" name="otp" class="form-control" required>
                    </div>
                    <button type="submit" name="verify_otp" class="btn btn-primary">Verify OTP</button>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<script>
    // Show the modal when the page loads
    $(document).ready(function () {
        $('#otpModal').modal('show');
    });
</script>

</body>
</html>

