

<?php
$trade_id            = $_POST['trade_id']        ?? '';
$accountfor          = $_POST['accountfor']      ?? '';
$account_number      = $_POST['account_number']  ?? '';
$withdraw_amount     = $_POST['withdraw_amount'] ?? 0;
$withdraw_type       = $_POST['withdraw_type']   ?? '';
$ifsc                = $_POST['ifsc']            ?? '';
$client_bank         = $_POST['client_bank']     ?? '';
$account_holder_name = $_POST['account_holder_name'] ?? '';
$email               = $_POST['email']           ?? '';
$otp                 = $_POST['otp']             ?? '';
$otpcode             = $_POST['otpcode']         ?? '';
$comment             = "Transfer - acc " . $trade_id . " to " . $accountfor;
$commentdb           = $_POST['comment']         ?? '';

$to_account          = $accountfor; // <-- destination account stored in DB

if ($otp != $otpcode) {
    echo "<script>alert('OTP does not matched try again');</script>";
    echo "<script>window.location.href='dashboard.php';</script>";
    exit;
}

define("PATH_TO_SCRIPTS", "mt5_api/");
include PATH_TO_SCRIPTS . "mt5_api.php";

define('T_QUOTES', 'EURUSD,GBPUSD,USDJPY,AUDUSD,USDCAD');
define("MT5_SERVER_IP", "access.tgshost.org");
define("MT5_SERVER_PORT", "26043");
define("MT5_SERVER_WEB_LOGIN", "7020");
define("MT5_SERVER_WEB_PASSWORD", "Aa@123456");

define("MT5_CRYPT_PROTOCOL", true);
define("IS_WRITE_DEBUG_LOG", true);
define("MT5_CONNECTION_TIMEOUT", 3);
define("PATH_TO_LOGS", "./logs");
define("AGENT", "WebAPITesterArt");

$api = new MTWebAPI(AGENT, PATH_TO_LOGS, MT5_CRYPT_PROTOCOL);
$api->SetLoggerWriteDebug(IS_WRITE_DEBUG_LOG);

// Connect to MT5
if (($error_code = $api->Connect(MT5_SERVER_IP, MT5_SERVER_PORT, MT5_CONNECTION_TIMEOUT, MT5_SERVER_WEB_LOGIN, MT5_SERVER_WEB_PASSWORD)) != MTRetCode::MT_RET_OK) {
    echo "<script>alert('Invalid Details');</script>";
    exit;
}

// Accounts
$login  = (int)$trade_id;    // source
$login2 = (int)$accountfor;  // destination

// Get source account
$account = null;
if (($error_code = $api->UserAccountGet($login, $account)) != MTRetCode::MT_RET_OK) {
    echo "Error: source account not found ($error_code)";
    exit;
} else {
    $balance    = $account->Balance;
    $credit     = $account->Credit;
    $profit     = $account->Floating;
    $freemargin = $account->MarginFree;
    $equity     = ($balance + $credit + $profit);
    $margin     = $account->Margin;
    $marginlevel= round((($balance - $freemargin) / 1000), 2);
}

// Get destination account
$account2 = null;
if (($error_code = $api->UserAccountGet($login2, $account2)) != MTRetCode::MT_RET_OK) {
    echo "Error: destination account not found ($error_code)";
    exit;
} else {
    $balance2    = $account2->Balance;
    $credit2     = $account2->Credit;   // fixed var name
    $profit2     = $account2->Floating;
    $freemargin2 = $account2->MarginFree;
    $equity2     = ($balance2 + $credit2 + $profit2); // fixed
    $margin2     = $account2->Margin;
    $marginlevel2= round((($balance2 - $freemargin2) / 1000), 2);
}

// MT5 balance operations
$type = MTEnDealAction::DEAL_BALANCE;

// 1) Deduct from source
if (($error_code = $api->UserDepositChange($login, -abs($withdraw_amount), $comment, $type)) != MTRetCode::MT_RET_OK) {
    echo "Error making deduction from source: " . $error_code;
    exit;
}

// 2) Credit destination
if (($error_code = $api->UserDepositChange($login2, abs($withdraw_amount), $comment, $type)) != MTRetCode::MT_RET_OK) {
    // Try to revert source debit
    $api->UserDepositChange($login, abs($withdraw_amount), "Revert failed transfer", $type);
    echo "Error crediting destination: " . $error_code;
    exit;
}

/* ================= DB part with to_account ================= */

$conn = new mysqli('localhost', 'crmcentrioglobal_crmvideonew', 'crmvideonew123', 'crmcentrioglobal_crmvideonew');
if ($conn->connect_error) {
    die("Database Connection failed: " . $conn->connect_error);
}
$conn->set_charset('utf8mb4');

$status     = 1;   // Approved / Completed
$utr_number = '';

// INSERT wallet_deposit (credit to destination)
$stmt_deposit = $conn->prepare(
    "INSERT INTO `wallet_deposit`
     (`email`, `trade_id`, `to_account`, `deposit_amount`, `deposit_type`, `deposted_date`, `Status`, `AdminRemark`, `utr_number`)
     VALUES (?, ?, ?, ?, ?, NOW(), ?, ?, ?)"
);
if (!$stmt_deposit) {
    die("Prepare failed for wallet_deposit: " . $conn->error);
}
$stmt_deposit->bind_param(
    'sssssiss',
    $email,            // s
    $accountfor,       // s (credited trade_id)
    $to_account,       // s (destination)
    $withdraw_amount,  // s (ok to pass as string/float)
    $withdraw_type,    // s
    $status,           // i
    $commentdb,        // s
    $utr_number        // s
);
if (!$stmt_deposit->execute()) {
    die("Error inserting into wallet_deposit: " . $stmt_deposit->error);
}
$stmt_deposit->close();

// INSERT wallet_withdraw (debit from source)
$stmt_withdraw = $conn->prepare(
    "INSERT INTO `wallet_withdraw`
     (`email`, `trade_id`, `to_account`, `withdraw_amount`, `withdraw_type`, `withdraw_date`, `Status`, `AdminRemark`)
     VALUES (?, ?, ?, ?, ?, NOW(), ?, ?)"
);
if (!$stmt_withdraw) {
    die("Prepare failed for wallet_withdraw: " . $conn->error);
}
$stmt_withdraw->bind_param(
    'sssssis',
    $email,            // s
    $trade_id,         // s (debited trade_id)
    $to_account,       // s (destination)
    $withdraw_amount,  // s
    $withdraw_type,    // s
    $status,           // i
    $commentdb         // s
);
if (!$stmt_withdraw->execute()) {
    die("Error inserting into wallet_withdraw: " . $stmt_withdraw->error);
}
$stmt_withdraw->close();

$conn->close();

echo "<script>window.location.href='transfer-message.php';</script>";
exit;

?>
